<?php
include_once('Field.class');
include_once('Row.class');
include_once('Preferences.class');
include_once('Form.class');
include_once('FormLabel.class');
include_once('FormRadio.class');
include_once('FormCheck.class');
include_once('FormSelect.class');
include_once('FormInput.class');
include_once('FormReset.class');
include_once('FormSubmit.class');
include_once('FormHidden.class');
include_once('Column.class');
include_once('Database.class');
include_once('Preferences.class');
include_once('session.php');
include_once('Transliterate_eo_EO.class');
include_once('Transliterate_cy_GB.class');

$l10nzilla_search_lastLine = null;
$l10nzilla_search_lastRow = null;
$singleFileID = null;
$singleFileName = null;

define(TEXT_SEARCH,1);
define(FILE_SEARCH,2);
define(COMBINED_SEARCH,3);
define(NO_SEARCH,4);


l10nzilla_main();

// ------------------------------------------------
function l10nzilla_main()
{
global	$mySession;

	checkSession();
	setLanguage();

	$preferences = & new Preferences();

	$database = & new Database(
	$preferences->databaseServer,
	$preferences->databaseName,
	$preferences->databaseUser,
	$preferences->databasePassword);
	$form = & new Form("search");

	Header("Content-type: text/html; charset=UTF-8");
	$mySession->ini_page();
	identifyAction($form,$database);
	l10nzilla_search_form($form,$database);
//	print $form->getHtml();
	l10nzilla_search_processActions($form,$database);
	l10nzilla_search_doSearch($form,$database);
	$mySession->end_page();
}
// ------------------------------------------------
function identifyAction(& $form,& $database)
{
global $singleFileID;
global $singleFileName;

	// Check the succesful control in order to decide what to do
	// Possible controls
	// Search	text search
	// FileSearch	file search
	// FileList	file list (ordered)
	// FileBrowse	file list (ordered by path and grouped)
	// ChooseFile_*	text search (just that one file)
	// See if there is a ChooseFile_xxx and act accordingly
	foreach ($_POST as $key => $value)
	{

		if (strncmp($key,"ChooseFile_",11) == 0)
		{
			$singleFileID = substr($key,11);
			$sql = "select concat(File_Location,File_Name) from Files " .
			"where File_ID=$singleFileID";
			$res = $database->query($sql);

			if ($therow = $database->getRow($res))
				$singleFileName = $therow[0];
			else
				$singleFileName = null;
			$database->freeResult($res);
		}
	}
}
// ------------------------------------------------
function l10nzilla_search_form(& $form,& $database)
{
global $mySession;
global $singleFileName;

	$gst = & new Group(_("Search and Translate"));
	$gst->setExtraAttributes($gst->buildAttribute("align","center") .
	$gst->buildAttribute("valign","top"));

	// -----------------------------------
	$geo = & new Group(_("General Options"));

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Version"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formInstallID");
	$xfield->addValuesFromDB($database,"select Install_Name,Install_ID from Installs order by Install_ID");
	$xrow->addColumn($xfield);
	$geo->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Language"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formLanguageID");
	$xfield->addValue("en","en");
	$xfield->addValue($mySession->translatorLanguage,$mySession->translatorLanguage);
	$xrow->addColumn($xfield);
	$geo->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Texts/Files"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formTranslated");
	$xfield->addValue(_("All"),"all");
	$xfield->addValue(_("Untranslated"),"untranslated");
	$xfield->addValue(_("Translated"),"translated");
	$xrow->addColumn($xfield);
	$geo->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Access keys?"));
	$xrow->addColumn($xfield);
	if ($form->getFormValue("formAccessKeys") !== FALSE)
		$xfield = & new FormCheck("formAccessKeys","on");
	else
		$xfield = & new FormCheck("formAccessKeys","");
	$xrow->addColumn($xfield);
	$geo->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormHidden("additionalTranslations","on");
	$xrow->addColumn($xfield);

	$geo->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormHidden("transliterateInput","on");
	$xrow->addColumn($xfield);
	$geo->addRow($xrow);

	// -----------------------------------
	$gts = & new Group(_("Text Search"));

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Criteria"));
	$xrow->addColumn($xfield);
		$idx = $form->getFormValue($rr);
	if ($form->getFormValue("SearchFiles") !== FALSE)
	{
		$xfield = & new FormInput("formSearchText","");
	}
	else
		$xfield = & new FormInput("formSearchText");
	$xrow->addColumn($xfield);

	$xfield = & new FormSubmit("Search",_("Search"));
	$xrow->addColumn($xfield);

	$gts->addRow($xrow);
	// -----------------------------------
	$gfs = & new Group(_("File Search"));

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Criteria"));
	$xrow->addColumn($xfield);
	if (!empty($singleFileName))
		$xfield = & new FormInput("formSearchFile",$singleFileName);
	else
		$xfield = & new FormInput("formSearchFile");

	$xrow->addColumn($xfield);
	$gfs->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormLabel(_("Sort by"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formFileBrowse");
	$xfield->addValue(_("Location"),"byLocation");
	$xfield->addValue(_("Translated Percentage"),"byTranslatedPercentage");
	$xrow->addColumn($xfield);
	$gfs->addRow($xrow);

	$xrow = & new Row();
	$xfield = & new FormSubmit("SearchFiles",_("Search"));
	$xrow->addColumn($xfield);
	$gfs->addRow($xrow);
	// -----------------------------------
	$xrow = & new Row();
	$xrow->addColumn($geo);
	$xcol = & new Column();
	$xcol->addField($gts);
//	$xcol->setExtraAttributes($xcol->buildAttribute("colspan","2") .
//	$xcol->buildAttribute("align","center"));
	$xrow->addColumn($xcol);
	$xrow->addColumn($gfs);
	$gst->addRow($xrow);
	$form->addGroup($gst);
}
// ------------------------------------------------
function processActionsTextSearch(& $form,& $database)
{
	// Iterate over all the fields
	for ($i = 0;$i < 1000;$i++)
	{
		$rr = "RowRef__" . $i;
		$idx = $form->getFormValue($rr);
		if ($idx !== FALSE)
		{
			$now = $form->getFormValue("TranslatedString",$idx);
			$before = $form->getFormValue("_O_TranslatedString",$idx);
			if (strcmp($before,$now) != 0)
			{
//print "Processing " . $_POST["RowRef__" . $i] . "<br>";
//print "--$idx--->$before|$now<br>";

				if (strlen($before) == 0)
					l10nzilla_search_addTranslation($database,$form,$idx);
				else if (strlen($now) == 0)
					l10nzilla_search_deleteTranslation($database,$form,$idx);
				else
					l10nzilla_search_modifyTranslation($database,$form,$idx);
			}
		}
		else
			break;
	}
}
// ------------------------------------------------
function processActionsFileSearch(& $form,& $database)
{
}
// ------------------------------------------------
function l10nzilla_search_processActions(& $form,& $database)
{
	$f = getSearchType($form);

	if ($f == TEXT_SEARCH || $f == COMBINED_SEARCH)
	{
		processActionsTextSearch($form,$database);
	}
	else if ($f == FILE_SEARCH)
	{
		processActionsFileSearch($form,$database);
	}
//showPost();
}
// ------------------------------------------------
function showPost()
{
	print "<table>";
	foreach($_POST as $key => $value)
	{
		print "<tr><td><b>$key</b></td><td>$value</td></tr>";
	}
	print "</table>";
}
// ------------------------------------------------
function doTextSearch(& $form,& $database)
{
}
// ------------------------------------------------
function doFileSearch(& $form,& $database)
{
}
// ------------------------------------------------
function l10nzilla_search_doSearch(& $form,& $database)
{
	// Is there anything to do/search

	$f = getSearchType($form);
	if ($f == NO_SEARCH)
	{
		print $form->getHtml();
		return null;
	}

	$sql = l10nzilla_search_getQuery($form);

	if ($sql != "")
	{
//print $sql;
		$result = $database->query($sql);
		$dataGroup = l10nzilla_Presentation($database,$result,$form);
		print $dataGroup;
	}
	return;
}
// ------------------------------------------------
function l10nzilla_Presentation(& $database,& $result,& $form)
{
	$t = getSearchType($form);

	if ($t == NO_SEARCH)
		return;
	else if ($t == FILE_SEARCH)
		return l10nzilla_FilePresentation($database,$result,$form);
	else
		return l10nzilla_TextPresentation($database,$result,$form);
}
// ------------------------------------------------
function l10nzilla_FilePresentation(& $database,& $result,& $form)
{
include_once("FilePresentation.class");

	$presentation = & new FilePresentation($database,$result);
	$a["View"] = "rvb";
	$a["File_Name"] = "vr";
	$a["Total_Labels"] = "vr";
	$a["Proposed_Translations"] = "vr";
	$a["Accepted_Translations"] = "vr";
	if ($form->getFormValue("formAccessKeys") !== FALSE)
	{
		$a["Total_AccessKeys"] = "vr";
		$a["Proposed_AccessKeys"] = "vr";
		$a["Accepted_AccessKeys"] = "vr";
	}

	$presentation->registerFields($a);
	$b = array(
		"File_Location"
	);
	$presentation->setCategory($b);

	$c[] = "Labels";
	$c[] = "Proposed";
	$c[] = "Accepted";

	if ($form->getFormValue("formAccessKeys") !== FALSE)
	{
		$c[] = "Keys";
		$c[] = "Proposed";
		$c[] = "Accepted";
	}

	$presentation->setHeaders($c);

	$presentation->setGlobalForm($form);

	return $presentation->getHtml();
}
// ------------------------------------------------
function l10nzilla_TextPresentation(& $database,& $result,& $form)
{
include_once("Presentation.class");

	$presentation = & new Presentation($database,$result);
		$a = array(
		"SourceText_ID" => "r",
		"Install_ID" => "r",
		"Status_ID" => "r",
		"Label_ID" => "r",
		"File_Name" => "r",
		"Quality_ID" => "r",
		"File_ID" => "r",
		"File_Location" => "r",
		"_TranslatedString" => "o",
		"TranslatedText_ID" => "r",
		"Translator_ID" => "r",
		"SourceString" => "vr",
		"Label_Name" => "vr",
		"TranslatedString" => "vrm"
		);
	$presentation->registerFields($a);
		$b = array(
		"File_Location",
		"File_Name"
		);
	$presentation->setCategory($b);

	$presentation->setGlobalForm($form);

	return $presentation->getHtml();
}
// ------------------------------------------------
function getSearchType(& $form)
{
global $mySession;
global $singleFileID;

	$formSearchText = $form->getFormValue("formSearchText");
	$formSearchFile = $form->getFormValue("formSearchFile");
	$formButtonSearchFiles = $form->getFormValue("SearchFiles");

	// Browsing just one file?
	if ($singleFileID)
		return TEXT_SEARCH;

	// There can be three searches: texts, files, combined.

	$t = ! empty($formSearchText);
	$f = ! empty($formSearchFile);
	$bf = ! empty($formButtonSearchFiles);

	if ($form->getFormValue("Process") !== FALSE)
	{
		if ($f)
			return COMBINED_SEARCH;
		else
			return TEXT_SEARCH;
	}

	if ($t && ! $f)
		return TEXT_SEARCH;
	else if ($t && ($f || $bf))
		return COMBINED_SEARCH;
	else if (! $t && ($f || $bf))
		return FILE_SEARCH;
	else
		return NO_SEARCH;
}
// ------------------------------------------------
function l10nzilla_search_getQuery(& $form)
{
global $mySession;

	$t = getSearchType($form);

	if ($t == TEXT_SEARCH)
		return getQueryText($form,FALSE);
	else if ($t == COMBINED_SEARCH)
		return getQueryText($form,TRUE);
	else if ($t == FILE_SEARCH)
		return getQueryFile($form);
	else
		return "";
}
// ------------------------------------------------
function getQueryText(& $form,$combined)
{
global $mySession;
global $singleFileID;

	$formSearchText = $form->getFormValue("formSearchText");
	$formSearchFile = $form->getFormValue("formSearchFile");
	$formInstallID = $form->getFormValue("formInstallID");
	$formLanguageID = $form->getFormValue("formLanguageID");
	$formTranslated = $form->getFormValue("formTranslated");

	if (strlen($formSearchText) == 0)
		$formSearchText = "%";

	// Looking for english or native lang texts?
	if ($formLanguageID == $mySession->translatorLanguage)
	{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,ilst.Lang_ID,Quality_ID,Files.File_ID,File_Name,File_Location,Label_Name,
		TranslatedString,tt.TranslatedText_ID,ilst.Translator_ID
		from TranslatedTexts as tt
		left join Installs_Labels_Source_Target as ilst
		using (TranslatedText_ID)
		left join Installs_Labels_Source as ils
		using(Install_ID,Label_ID,SourceText_ID)
		left join Labels as l on l.Label_ID = ils.Label_ID
		left join Files using (File_ID)
		left join SourceTexts as st
		on st.SourceText_ID = ilst.SourceText_ID";
	}
	else
	{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,ilst.Lang_ID,File_Name,Quality_ID,Files.File_ID,File_Location,Label_Name,
		TranslatedString,tt.TranslatedText_ID,tt.Translator_ID
		from SourceTexts as st
		left join Installs_Labels_Source as ils using(SourceText_ID)
		left join Installs_Labels_Source_Target as ilst
		using (Install_ID,Label_ID,SourceText_ID)
		left join Labels as l on l.Label_ID = ils.Label_ID
		left join Files using (File_ID)
		left join TranslatedTexts as tt
		on tt.TranslatedText_ID = ilst.TranslatedText_ID";
	}

	// Just the current install
	$sql .= " where ils.Install_ID = $formInstallID ";

	// Take care of single file view
	if (isset($singleFileID))
		$sql .= " and l.File_ID = $singleFileID ";

	// Is it a combined search?
	if ($combined)
	{
		$sql .= " and concat(File_Location,File_Name) like " .
		"'$formSearchFile' ";
	}

	if (strcmp($formSearchText,"%") != 0)
	{
	// Uppercase the search text (it's a blob, that's why)
	$upper = strtoupper($formSearchText);

	if ($formLanguageID == $mySession->translatorLanguage)
	{
		if ($form->getFormValue("transliterateInput"))
		{
			$upper = strtoupper($mySession->transliteration->xToUnicode($formSearchText));
		}
		$sql.= " and upper(TranslatedString) like '$upper'";
	}
	else
		$sql.= " and upper(SourceString) like '$upper'";
	}
	// Accesskey/Key inclusion (for now anything with length=1
	if ($form->getFormValue("formAccessKeys") === FALSE)
		$sql .= " and length(SourceString) != 1 ";

	// Which texts to show?  Translated/Untranslated/All
	if ($formTranslated == "translated")
		$sql .= " and (KeepOriginal = 1 or
		ilst.TranslatedText_ID is not null) ";
	else if ($formTranslated == "untranslated")
		$sql .= " and ((KeepOriginal = 0 or KeepOriginal is null) and
		ilst.TranslatedText_ID is null) ";

	// Set the language
	$sql .= " and (ilst.Lang_ID = '{$mySession->translatorLanguage}'
	or ilst.Lang_ID is null)";

	// Set the grouping
	$sql .= " group by Files.File_ID,SourceString
	 order by Files.File_ID,SourceString";
//print "<h1>Query: $sql</h1>";
	return $sql;
}
// ------------------------------------------------
function getQueryFile(& $form)
{
global $mySession;

	$formSearchText = $form->getFormValue("formSearchText");
	$formSearchFile = $form->getFormValue("formSearchFile");
	$formInstallID = $form->getFormValue("formInstallID");
	$formLanguageID = $form->getFormValue("formLanguageID");
	$formTranslated = $form->getFormValue("formTranslated");

	$sql = "select * from Files_Statistics as fs,Files as f where fs.File_ID = f.File_ID and fs.Install_ID = $formInstallID ";

	// Which files to show?  Translated/Untranslated/All
	/*
	if ($formTranslated == "translated")
		$sql .= " and (KeepOriginal = 1 or
		ilst.TranslatedText_ID is not null) ";
	else if ($formTranslated == "untranslated")
		$sql .= " and ((KeepOriginal = 0 or KeepOriginal is null) and
		ilst.TranslatedText_ID is null) ";
	*/
	$sql .= " and fs.Lang_ID = '{$mySession->translatorLanguage}' ";

	// Only some files?
	if (strlen($formSearchFile) != 0)
	{
		$sql .= " and concat(f.File_Location,f.File_Name) like " .
		"'$formSearchFile' ";
	}

	// Set the ordering/grouping
	$sortBy = $form->getFormValue("formFileBrowse");
	if (strcmp($sortBy,"byLocation") == 0)
		$orderBy = " order by f.File_Location";
	else if (strcmp($sortBy,"byTranslatedPercentage") == 0)
		$orderBy = " order by Total_Labels - Accepted_Translations desc";

	$sql .= $orderBy;
//print "<h1>Query: $sql</h1>";
	return $sql;
}
// ------------------------------------------------
// ------------------------------------------------
function l10nzilla_search_modifyTranslation(& $database,& $form,$idx)
{
global $mySession;

	// Modify TranslatedTexts
	$ttid = $form->getFormValue("TranslatedText_ID",$idx);
	$tttx = $form->getFormValue("TranslatedString",$idx);
	if ($form->getFormValue("transliterateInput"))
		$tttx = $mySession->transliteration->xToUnicode($tttx);

	$sql = "update TranslatedTexts set Quality_ID=2,TranslatedString='$tttx' where TranslatedText_ID=$ttid";
//print "<h1>Modify: $sql</h1>";
	$database->query($sql);
	return;
}
// ------------------------------------------------
function l10nzilla_search_addTranslation(& $database,& $form,$idx)
{
global $mySession;

	// Add TranslatedText
	$translatedTextID = l10nzilla_maximum($database,"TranslatedText_ID","TranslatedTexts");
	$translatedString = $form->getFormValue("TranslatedString",$idx);
	if ($form->getFormValue("transliterateInput"))
		$translatedString = $mySession->transliteration->xToUnicode($translatedString);

	$langID = $mySession->translatorLanguage;
	$translatorID = $mySession->translatorID;
	$statusID = 0; // Default status
	$sql = "replace into TranslatedTexts
	(TranslatedText_ID,Lang_ID,Status_ID,TranslatedString,Translator_ID,Quality_ID)
	values ($translatedTextID,\"$langID\",$statusID,\"$translatedString\",
	$translatorID,2)";
	$database->query($sql);
//print "<h1>Add(1): $sql</h1>";

	// Add "line" in ilst

	$installID = $form->getFormValue("formInstallID");
	$labelID = $form->getFormValue("Label_ID",$idx);
	$sourceTextID = $form->getFormValue("SourceText_ID",$idx);

	$sql = "replace into Installs_Labels_Source_Target
	(Install_ID,Label_ID,SourceText_ID,TranslatedText_ID,Lang_ID,Translator_ID)
	values ($installID,$labelID,$sourceTextID,$translatedTextID,
	\"$langID\",$translatorID)";
	$database->query($sql);

//print "<h1>Add(2): $sql</h1>";

	// Update Files_Statistics
	$currentQualityID = $form->getFormValue("Quality_ID",$idx);
	$fileID = $form->getFormValue("File_ID",$idx);
	$sql = "select * from Files_Statistics where File_ID=$fileID" .
	" and Install_ID=$installID";
	$result = $database->query($sql);
	if (($therow = $database->getRow($result)) !== FALSE)
	{
		$proposed = $therow["Proposed_Translations"];
		$accepted = $therow["Accepted_Translations"];
		$proposed++;
		$update_sql = "update Files_Statistics set" .
		" Proposed_Translations=$proposed," .
		" Accepted_Translations=$accepted where " .
		" File_ID=$fileID and Install_ID=$installID";
		$database->query($update_sql);
	}
	$database->freeResult($result);

	return;
}
// ------------------------------------------------
function l10nzilla_search_deleteTranslation(& $database,& $form,$idx)
{
global $mySession;

	// Delete TranslatedText
	$ttid = $form->getFormValue("TranslatedText_ID",$idx);
	$sql = "delete from TranslatedTexts where TranslatedText_ID=$ttid";
//print "<h1>Delete(1): $sql</h1>";
	$database->query($sql);

	// Delete line in ilst

	$installID = $form->getFormValue("formInstallID");
	$labelID = $form->getFormValue("Label_ID",$idx);
	$sourceTextID = $form->getFormValue("SourceText_ID",$idx);
	$langID = $mySession->translatorLanguage;
	$translatorID = $mySession->translatorID;

	$sql = "delete from Installs_Labels_Source_Target where
	Install_ID=$installID and Label_ID=$labelID and
	SourceText_ID=$sourceTextID and TranslatedText_ID=$ttid
	and Lang_ID='$langID' and Translator_ID=$translatorID";
//print "<h1>Delete(2): $sql</h1>";
	$database->query($sql);

	// Go get File_Statistics (consider current Quality_ID)
	$currentQualityID = $form->getFormValue("Quality_ID",$idx);
	$fileID = $form->getFormValue("File_ID",$idx);
print "<h1>$fileID/ $installID</h1>";
	$sql = "select * from Files_Statistics where File_ID=$fileID" .
	" and Install_ID=$installID";
	$result = $database->query($sql);
	if (($therow = $database->getRow($result)) !== FALSE)
	{
		$proposed = $therow["Proposed_Translations"];
		$accepted = $therow["Accepted_Translations"];
		$proposed--;
		if ($currentQualityID == 1 || $currentQualityID == 3)
			$accepted--;
		$update_sql = "update Files_Statistics set" .
		" Proposed_Translations=$proposed," .
		" Accepted_Translations=$accepted where " .
		" File_ID=$fileID and Install_ID=$installID";
		$database->query($update_sql);
	}
	$database->freeResult($result);
	return;
}
// ------------------------------------------------
function l10nzilla_maximum(& $database,$field,$table)
{
	$sql = "select max($field) + 1 as maxNumber from $table";
	$res = $database->query($sql);
	$num = 0;
	if ($row = $database->getRow($res))
	{
		$num = $row["maxNumber"];
	}
	$database->freeResult($res);

	if ($num == NULL)
		$num = 0;

	return($num);
}
// ------------------------------------------------
function errmessage($a)
{
	print "<h1>$a</h1>";
}
// ------------------------------------------------
/*
	function deleteTranslation()
	{
	global $page;

		$translatorID = $page->translatorID;
		$langID = $page->preferences->myLanguage;
		$installID = getFormValue("installID");
		$statusID = getFormValue("statusID");
		$translatedString = getFormValue("translatedString");
		$labelID = getFormValue("labelID");
		$sourceTextID = getFormValue("sourceTextID");

		$sql = "select * from Installs_Labels_Texts where
		Label_ID=$labelID and Install_ID=$installID and
		SourceText_ID=$sourceTextID";
		$res = $page->database->query($sql);
//print $sql;
		if ($row = $page->database->getRow($res))
		{
			$translatedTextID = $row["TranslatedText_ID"];
			$sql = "delete from TranslatedTexts where
			TranslatedText_ID=$translatedTextID";
			$aux = $page->database->query($sql);
//print $sql;
		}
		else
		{
			$page->database->freeResult($res);
			return;
		}
		$page->database->freeResult($res);

		$sql = "update Installs_Labels_Texts
		set TranslatedText_ID=null
		where Install_ID=$installID
		and Label_ID=$labelID
		and SourceText_ID=$sourceTextID";
		$aux = $page->database->query($sql);
//print $sql;
		return;
	}
function l10nzilla_search_getQuery(& $form)
{
global $mySession;

	$formSearchText = $form->getFormValue("formSearchText");
	$formFileName = $form->getFormValue("formFileName");
	$formInstallID = $form->getFormValue("formInstallID");
	$formLanguageID = $form->getFormValue("formLanguageID");
	$formTranslated = $form->getFormValue("formTranslated");

	if ($formSearchText == "" && $formFileName == "")
		return "";


	if (strlen($formSearchText) > 0)
	{
		if ($formLanguageID == $mySession->translatorLanguage)
		{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,ilst.Lang_ID,Quality_ID,Files.File_ID,File_Name,File_Location,Label_Name,
		TranslatedString,tt.TranslatedText_ID,ilst.Translator_ID
		from TranslatedTexts as tt
		left join Installs_Labels_Source_Target as ilst
		using (TranslatedText_ID)
		left join Installs_Labels_Source as ils
		using(Install_ID,Label_ID,SourceText_ID)
		left join Labels as l on l.Label_ID = ils.Label_ID
		left join Files using (File_ID)
		left join SourceTexts as st
		on st.SourceText_ID = ilst.SourceText_ID";
		}
		else
		{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,ilst.Lang_ID,File_Name,Quality_ID,Files.File_ID,File_Location,Label_Name,
		TranslatedString,tt.TranslatedText_ID,tt.Translator_ID
		from SourceTexts as st
		left join Installs_Labels_Source as ils using(SourceText_ID)
		left join Installs_Labels_Source_Target as ilst
		using (Install_ID,Label_ID,SourceText_ID)
		left join Labels as l on l.Label_ID = ils.Label_ID
		left join Files using (File_ID)
		left join TranslatedTexts as tt
		on tt.TranslatedText_ID = ilst.TranslatedText_ID";
		}

//using (Install_ID,Label_ID,SourceText_ID)
		$sql .= " where ils.Install_ID = $formInstallID ";

		$upper = strtoupper($formSearchText);

		if ($formLanguageID == $mySession->translatorLanguage)
		{
			if ($form->getFormValue("transliterateInput"))
			{
				$upper = strtoupper($mySession->transliteration->xToUnicode($formSearchText));
			}
			$sql.= " and upper(TranslatedString) like '$upper'";
		}
		else
			$sql.= " and upper(SourceString) like '$upper'";
	}
	if (strlen($formFileName) > 0)
	{
		if (strlen($formSearchText) == 0)
		{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,File_Name,File_Location,Label_Name,
		TranslatedString
		from Files
		left join Labels using (File_ID)
		left join Installs_Labels_Source as ils using(Label_ID)
		left join Installs_Labels_Source_Target as ilst
		using (Install_ID,Label_ID,SourceText_ID)
		left join SourceTexts as st using (SourceText_ID)
		left join TranslatedTexts as tt
		on tt.TranslatedText_ID = ilst.TranslatedText_ID";

		$sql .= " where ils.Install_ID = $formInstallID ";
		}

		$upper = strtoupper($formFileName);
		$sql .= " and upper(concat(Files.File_Location,
		Files.File_Name)) like '$upper'";
	}
	/
	if (!$form->getFormValue("formAccessKey"))
		$sql .= " and Label_Name not like \"%key\" and  Label_Name not like \"%.keybinding\" ";
	/
//	$sql .= " and SourceString not like '_' ";
	if ($formTranslated == "translated")
		$sql .= " and (KeepOriginal = 1 or
		ilst.TranslatedText_ID is not null) ";
	else if ($formTranslated == "untranslated")
		$sql .= " and ((KeepOriginal = 1 or KeepOriginal is null) and
		ilst.TranslatedText_ID is null) ";

	$sql .= " and (ilst.Lang_ID = '{$mySession->translatorLanguage}'
	or ilst.Lang_ID is null)";
	$sql .= " group by Files.File_ID,SourceString
	 order by Files.File_ID,SourceString";
//print "<h1>Query: $sql</h1>";
	return $sql;
}
// ------------------------------------------------
	*/
?>
