/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License") you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code in this file was released April 1, 2001
 * 
 * The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
 * all Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
 * by Henk-Johan van Rantwijk. All Rights Reserved.
 * 
 * Contributor(s):
 *   Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
 *   David Perry <d.perry@utoronto.ca>
 *   Neil Pryde <NeilPryde92651@netscape.net> (well I'm just HJ's typewriter)
 * 
 */

////////////////////////////////////////////////////////////////////////////////
// Javascript functions used to handle the UI for the MultiZilla extension
// Current version : 1.0.78 (1.0.xx versions are my private Alpha releases)
// Written by : (HJ) Henk-Johan van Rantwijk <bugs4hj@netscape.net>
////////////////////////////////////////////////////////////////////////////////

var mvSelectedTab   = null;
var mvNewStickyName = null;
var mvSelectedTab   = 0;
var mvTotalTabs     = 0;
var mvMinTabs       = 1;
var mvMaxTabs       = 0;
var mvPopupNode     = null; // document.popupNode is wrong after 2001041704 
var mvTabboxElement = null;
var mvDeckElement   = null;
var mvBlankLabel    = null;
var mvCantClose     = null;
var mvCantOpen      = null;
var mvStickyLabel   = null;
var mvBundle        = null;
var mvPrefsFailure  = null;
var mvHomePage      = null;
var mvLoadDelay     = 25; // without this hack, all pages load blank
// var mvPrefs         = null;
var mvNewTabURI     = null;
var mvLastActiveTab = null;
var mvVersion       = "v1.0.78 Alpha";
var mvLinkList      = new Array(); // to save the tab/view's URL in it

// preference settings
var mvMaxStickyLen    = 25;
var mvMinStickyLen    = 10;
var mvPreventDouble   = false;
var mvTopTabs         = false;
var mvmvLabelStickyPref = false;
var mvFirstBrowser    = false;
var mvNewPreferred    = null;
var mvPrefWarning     = true;
var mvTitleSticky     = false;
var mvUrlOnTab        = false;
var mvHiddenTabs      = false;
var mvAutohideTabs    = false;
var mvSecretGarden    = false;
var mvTitleHold       = false;
var mvMMClickNewTab   = false;
var mvBMarksNewTab    = false;
var mvPToolbarNewTab  = false;
var mvDevTooltips     = false;

// new object to replace preference var's
var mvPrefs = new Object();

// tabSelectors
var BLANK           = 0;
var HOME            = 1;
var CLIPBOARD       = 2;
var CURRENT         = 3;
var LOCATION        = 4;
var CONTEXT         = 5;
var PREFERRED       = 6;
var BOOKMARK        = 7;

// WARNING: CHANGE THIS WHEN MOVING FILES - strings localization file!
var multiviewsBundle = "chrome://multiviews/locale/multiviews.properties";

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions to: initialize MultiZilla
//
////////////////////////////////////////////////////////////////////////////////
// this function initializes MultiZilla
////////////////////////////////////////////////////////////////////////////////
function mvStartup() {
  var mvURL;
  initPrefsObject();
  // activate corresponding menu option "Close/Close Active Tab"
  document.getElementById( "menu_close" ).setAttribute( "hidden", MultiZilla );
  document.getElementById( "menuTab_close" ).setAttribute( "hidden", !MultiZilla );

  mvTabboxElement = document.getElementById( "multiviewTabBox" );
  mvDeckElement   = document.getElementById( "myViewportID" );
  mvUrlBar        = document.getElementById( "urlbar" );
  mvSecurityLock  = document.getElementById( "security-padlock" );

  // select default tab
  mvTabboxElement.selectedTab = mvTabboxElement.firstChild;

  // read the localized labels from multiviews.properties
  mvBundle        = srGetStrBundle( multiviewsBundle );
  mvMaxTabs       = mvBundle.GetStringFromName( "maxTabs" );
  mvMaxTabs--;
  mvBlankLabel    = mvBundle.GetStringFromName( "blankLabel" );
  mvCantOpen      = mvBundle.GetStringFromName( "cantOpen" );
  mvCantClose     = mvBundle.GetStringFromName( "cantClose" );
  mvStickyLabel   = mvBundle.GetStringFromName( "stickyLabel" );
  mvPrefsFailure  = mvBundle.GetStringFromName( "prefsFailure" );
  mvHomePage      = mvBundle.GetStringFromName( "homePage" );

  // read some preference settings, must be moved to a function
  mvPrefWarning = readMyPref( "multizilla.display.prefwarning", "true or false", true );
  mvNewPreferred = readMyPref( "multizilla.new.preferred", "any valid URL", "http://multizilla.mozdev.org" );
  mvMaxStickyLen = readMyPref( "multizilla.sticky.maxlen", "min 10 - max 35", 25 );

  if ( ( mvMaxStickyLen < mvMinStickyLen ) || ( mvMaxStickyLen > 35 ) )
    mvMaxStickyLen = 25;

  mvTitleSticky = readMyPref( "multizilla.sticky.title", "true or false", true );
  mvAutohideTabs = readMyPref( "multizilla.tabs.autohide", "true or false", false );
  mvMMClickNewTab  = readMyPref( "multizilla.mouse-middle-click.newtab", "true or false", false );
  mvBMarksNewTab = readMyPref( "multizilla.bookmarks.newtab", "true or false", false );
  mvPToolbarNewTab = readMyPref( "multizilla.personal-toolbar.newtab", "true or false", false );
  mvSecretGarden = readMyPref( "multizilla.developer.tooltips", "true or false", false );
  mvSecretGarden = readMyPref( "multizilla.secret.garden", "true or false", false );

  // pref setting active so don't display tabs
  if ( ( mvAutohideTabs ) || ( mvSecretGarden ) )
    toggleTabs(); // this call will hide the tabbox and corresponding separator

  mvTitleHold = readMyPref( "multizilla.title.hold", "true or false", false );
  mvPreventDouble = readMyPref( "multizilla.prevent.double", "true or false", true );

  // TODO: check if the user started mozilla with 'filename.ext'
  mvURL = getHomePage();
  document.getElementById( "content" ).setAttribute( "id", "View-0" );
  document.getElementById( "View-0" ).setAttribute( "home", mvURL );
  document.getElementById( "aboutMultiZilla" ).removeAttribute( "hidden" );
  // TODO: check what has changed to make this call neccessary
  // we sure didn't need this before, but if removed, the homepage isn't displayed
  toggleShowHideButton();
  toggleOpenNewButton();
  loadViewURI( mvURL );
  setGoMenuOptions();
  // updateTabLocation();
}
////////////////////////////////////////////////////////////////////////////////
// this function (re)initializes the prefs object
////////////////////////////////////////////////////////////////////////////////
function initPrefsObject() {
 mvPrefs.Version         = 25;
 mvPrefs.MaxStickyLen    = 10;
 mvPrefs.MinStickyLen    = false;
 mvPrefs.PreventDouble   = false;
 mvPrefs.TopTabs         = false;
 mvPrefs.LabelStickyPref = false;
 mvPrefs.FirstBrowser    = false;
 mvPrefs.NewPreferred    = null;
 mvPrefs.PrefWarning     = false;
 mvPrefs.TitleSticky     = false;
 mvPrefs.UrlOnTab        = false;
 mvPrefs.HiddenTabs      = false;
 mvPrefs.AutohideTabs    = false;
 mvPrefs.SecretGarden    = false;
 mvPrefs.TitleHold       = false;
 mvPrefs.MMClickNewTab   = false;
 mvPrefs.BMarksNewTab    = false;
 mvPrefs.PToolbarNewTab  = false;
 mvPrefs.DevTooltips     = false;
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes the tab position at startup
////////////////////////////////////////////////////////////////////////////////
function initTabPosition() {

  MultiZilla = true;

  if ( readMyPref( "multizilla.tab.position", "top or bottom", "bottom" ) == "top" )
    mvTopTabs = true;

  if ( mvTopTabs ) { // Put the tabs on top of the window
    setTabProperty( "false", "true" ); // unhide top tabs and hide bottom tabs
    document.getElementById( "TabBoxTop" ).setAttribute( "id", "multiviewTabBox" );
    document.getElementById( "TabTop" ).setAttribute( "id", "Tab-0" );

    // remove unnecessary junk from XUL document
    while ( document.getElementById( "TabBoxBottom" ).hasChildNodes() ) {
      document.getElementById( "TabBoxBottom" ).removeChild( document.getElementById( "TabBoxBottom" ).lastChild );
    }
  }
  else { // Put the tabs on bottom of the window
    setTabProperty( "true", "false" ); // unhide bottom tabs and hide top tabs
    document.getElementById( "TabBoxBottom" ).setAttribute( "id", "multiviewTabBox" );
    document.getElementById( "TabBottom" ).setAttribute( "id", "Tab-0" );

    // remove unnecessary junk from XUL document
    while ( document.getElementById( "TabBoxTop" ).hasChildNodes() ) {
      document.getElementById( "TabBoxTop" ).removeChild( document.getElementById( "TabBoxTop" ).lastChild );
    }
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes the tab contextmenu
////////////////////////////////////////////////////////////////////////////////
function initTabContextMenu() {
  mvPopupNode = document.popupNode;
  // workaround for bug # 79416
  // var popupNode = document.popupNode;
  // filter out all unnecessary calls for this function
  if ( mvPopupNode.nodeName == 'button' ) // use the settings of the selected tab
    mvPopupNode = mvTabboxElement.selectedTab;
  else if ( mvPopupNode.nodeName != 'tab' )
    return;

  mvView = document.getElementById( mvPopupNode.getAttribute( "link" ) );
  mvLabel = mvPopupNode.getAttribute( "label" );
  mvElement = document.getElementById( "doCmd_tabHome" );

  ///////////////////////////////////////////////////
  // check if we currently have a StickyName set
  ///////////////////////////////////////////////////
  if( mvPopupNode.getAttribute( "stickyname" ) == "true" ) {
  // if ( mvLabel != mvBlankLabel && mvLabel != "about:blank" && mvLabel != "file:" ) {
    document.getElementById( "setStickyMenuItem" ).setAttribute( "hidden", "true" );
    document.getElementById( "clearStickyMenuItem" ).setAttribute( "hidden", "false" );
  }
  else {
    document.getElementById( "setStickyMenuItem" ).setAttribute( "hidden", "false" );
    document.getElementById( "clearStickyMenuItem" ).setAttribute( "hidden", "true" );
  }
  ///////////////////////////////////////////////////
  // check to see if 'Hide From Close All' is active
  ///////////////////////////////////////////////////
  if ( mvPopupNode.getAttribute( "close" ) == "false" )
    document.getElementById( "hideTab" ).setAttribute( "checked", "true" );
  else document.getElementById( "hideTab" ).setAttribute( "checked", "false" );
  //////////////////////////////////////////
  // check to see if 'Tab Locked' is active
  //////////////////////////////////////////
  if ( mvPopupNode.getAttribute( "locked" ) == "true" )
    document.getElementById( "lockedTab" ).setAttribute( "checked", "true" );
  else document.getElementById( "lockedTab" ).setAttribute( "checked", "false" );
  /////////////////////////////////////////////////////////
  // check to see if 'Tab Home' menuitem should be enabled
  /////////////////////////////////////////////////////////
  if ( mvView.getAttribute( "home" ) == getCurrentContentURI() )
    mvElement.setAttribute( "disabled", "true" );
  else mvElement.removeAttribute( "disabled" );

  // disable Tab contextmenu options
  setGoMenuOptions( true );
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes some listeners
////////////////////////////////////////////////////////////////////////////////
function mvInit() {
  var mvWebNavigation = getWebNavigation();

  // initialize observers and listeners

  // we set/activate our own status listener/handler here
  // window.XULBrowserWindow = new nsBrowserStatusHandler();
  // window.XULBrowserWindow = new nsBrowserStatusHandler( document.getElementById( "statusbar-icon" ) );
  var BSHandlers = [];
  // var handler = new nsBrowserStatusHandler( document.getElementById( "my-status" ) );
  var handler = new nsBrowserStatusHandler(	document.getElementById( "statusbar-icon" ) );
  BSHandlers.push( handler );
	
  // we set/activate our own button listener/handler here
  // window.buttonPrefListener = new nsButtonPrefListener();
  var BBSHandlers = [];
  handler = new nsButtonPrefListener();
  BBSHandlers.push( handler );

  // we set/activate our own content listener/handler here
  // window.browserContentListener = new nsBrowserContentListener( window, getBrowser() );  

  // window.browserContentListener = new nsBrowserContentListener();
  /* var BCHandlers = [];
  handler = new nsBrowserContentListener( window, getBrowser() );
  BCHandlers.push( handler ); */

  // Add a capturing event listener to the content area
  var mvContentArea = document.getElementById( "appcontent" );
  mvContentArea.addEventListener( "load", loadEventHandlers, true );
  mvContentArea.addEventListener( "focus", contentAreaFrameFocus, true );

  // wire up session history before any possible progress notifications for back/forward button updating
  mvWebNavigation.sessionHistory = Components.classes[ "@mozilla.org/browser/shistory;1" ]
                                   .createInstance( Components.interfaces.nsISHistory );

  // hook up UI through progress listener
  var mvInterfaceRequestor = getBrowser().docShell.QueryInterface( Components.interfaces.nsIInterfaceRequestor );
  var mvWebProgress = mvInterfaceRequestor.getInterface( Components.interfaces.nsIWebProgress );
  mvWebProgress.addProgressListener( window.XULBrowserWindow );

  // make sure it works after a theme switch, see bug 68662
  getBrowser().boxObject.setPropertyAsSupports( "listenerkungfu", window.XULBrowserWindow );
}
////////////////////////////////////////////////////////////////////////////////
// this function add menu items to the 'Context' and 'Go' menu
////////////////////////////////////////////////////////////////////////////////
function setGoMenuOptions( option ) {

  if ( option ) 
    var tabId = new Array( 'activateFirstTab','activateNextTab','activatePriorTab','activateLastTab' );
  else
    var tabId = new Array( 'gotoFirstTab','gotoNextTab','gotoPriorTab','gotoLastTab' );

  if ( MultiZilla ) {
    document.getElementById( "goMenuTopSeparator" ).removeAttribute( "hidden" );

    for ( var i = 0; i < 4; i++ )
      document.getElementById( tabId[ i ] ).removeAttribute( "hidden" );

    if ( mvTotalTabs > 0 ) {
      for ( var i = 0; i < 4; i++ )
        document.getElementById( tabId[ i ] ).removeAttribute( "disabled" );
    }
    else {
      for ( var i = 0; i < 4; i++)
        document.getElementById( tabId[ i ] ).setAttribute( "disabled", "true" );
    }
  }
  else
    document.getElementById( "goMenuTopSeparator" ).setAttribute( "hidden", "true" );
}

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: Tabs
//
////////////////////////////////////////////////////////////////////////////////
// this function switches the tab position from top to bottom or bottom to top
////////////////////////////////////////////////////////////////////////////////
function switchTabPosition() {

  if ( mvTopTabs ) { // Tabs on top of window active
    copyTabs( "multiviewTabBox", "TabBoxBottom" );
    mvTopTabs = false;
    setTabProperty( "true", "false" );
    document.getElementById( "multiviewTabBox" ).setAttribute( "id", "TabBoxTop" );
    document.getElementById( "TabBoxBottom" ).setAttribute( "id", "multiviewTabBox" );
  }
  else { // Tabs on the bottom of window active
    copyTabs( "multiviewTabBox", "TabBoxTop" );
    mvTopTabs = true;
    setTabProperty( "false", "true" );
    document.getElementById( "multiviewTabBox" ).setAttribute( "id", "TabBoxBottom" );
    document.getElementById( "TabBoxTop" ).setAttribute( "id", "multiviewTabBox" );
  }
  mvTabboxElement = document.getElementById( "multiviewTabBox" );
  mvHiddenTabs = false; // we have displayed the tabs, so reset this
  toggleShowHideButton();
  toggleOpenNewButton();
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a tab/view and sets the preselected URI
////////////////////////////////////////////////////////////////////////////////
function addNewBlank( mvTabSelector ) {

  // save a reference to the current active Tab
  mvLastActiveTab = mvTabboxElement.selectedTab;

  if ( mvTotalTabs < mvMaxTabs ) {
    var mvURI = getCurrentContentURI();

    if ( ( mvTabSelector == BOOKMARK ) && ( mvPreventDouble ) ) {
      // check preference setting
      var mvTab = getViewByURL( mvURI );
      // did we find this location?
      if ( mvTab != null ) {
        activateView( mvTab );
        mvTabboxElement.selectedTab = mvTab; 
        return;
      }
    }
    // are the tabs hidden?
    if ( mvHiddenTabs )
      toggleTabs();

    addTab();
    addView();
    mvTabboxElement.selectedTab = mvTabboxElement.lastChild;
    var mvLink = mvTabboxElement.selectedTab.getAttribute( "link" );
    activateView( mvTabboxElement.selectedTab );

    switch ( mvTabSelector ) {
        case HOME:      mvURI = getHomePage();
                        break;
        case CLIPBOARD: mvURI = getLocationFromClipboard();
                        break;
        case CURRENT:   break;
        case LOCATION:  BrowserOpenWindow();
                        mvURI = getCurrentContentURI();
                        break;
        case CONTEXT:   mvURI = mvNewTabURI;
                        break;
        case PREFERRED: if ( mvNewPreferred != null )
                        mvURI = mvNewPreferred;
                        break;
        case BOOKMARK:  OpenBookmarkURL( event.target, document.getElementById( 'BookmarksMenu' ).database );
                        break;
        default: mvURI = "about:blank";
                        break;
    }
    mvTabboxElement.selectedTab.setAttribute( "label", defineShortURL( mvURI ) );
    document.getElementById( mvLink ).setAttribute( "home", mvURI );
    setTimeout( "mvInit()", mvLoadDelay );

    if ( mvTabSelector != LOCATION )
      loadViewURI( mvURI );
    // disable 'Go' menu options
    setGoMenuOptions();
    // disable Tab contextmenu options
    setGoMenuOptions( true );
    // TODO: we need to get rid of this about:blank stuff in the urlbar
    // updateURLBar( mvURI ); // this doesn't work here!
    // setTimeout( "mvUrlBar.value = ''", 200 );
  }
  else
    alert( mvCantOpen );
 return;
}
////////////////////////////////////////////////////////////////////////////////
// this function adds a new tab
////////////////////////////////////////////////////////////////////////////////
function addTab() {
  var mvNewTab = document.createElement( "tab" );

  mvTotalTabs++;
  mvNewTab.setAttribute( "id", "Tab-" + mvTotalTabs );

  // do we need tabs on the top or on the bottom of the window?
  if ( mvTopTabs )
    mvNewTab.setAttribute( "class", "tab" );
  else 
    mvNewTab.setAttribute( "class", "tab-bottom" );
	
  mvNewTab.setAttribute( "tooltip", "aTooltip" );
  // TODO: check if this can be removed!
  mvNewTab.setAttribute( "tooltiptext", "Tooltip for Tab-" + ( mvTotalTabs + 1 ) );
  mvNewTab.setAttribute( "popupanchor", "bottomleft" );
  mvNewTab.setAttribute( "context", "tabContextMenu" );
  mvNewTab.setAttribute( "link", "View-" + mvTotalTabs );
  mvNewTab.setAttribute( "viewport", mvTotalTabs );
  mvNewTab.setAttribute( "close", "true" );
  mvNewTab.setAttribute( "locked", "false" );
  mvNewTab.setAttribute( "stickyname", "false" );
  mvNewTab.setAttribute( "onmouseover", "showUrl( event )" );
  mvNewTab.setAttribute( "onmouseout", "window.status=''" );
  mvNewTab.setAttribute( "oncommand", "activateView( this )" );
  // added new set of attributes for the new tabDNDObserver
  mvNewTab.setAttribute( "ondraggesture", "nsDragAndDrop.startDrag(event, tabDNDObserver)" );
  mvNewTab.setAttribute( "ondragover"," nsDragAndDrop.dragOver( event, tabDNDObserver )" );
  mvNewTab.setAttribute( "ondragdrop"," nsDragAndDrop.drop( event, tabDNDObserver )" );
  mvNewTab.setAttribute( "ondragexit"," nsDragAndDrop.dragExit( event, tabDNDObserver )" );
  mvTabboxElement.appendChild( mvNewTab );
}
////////////////////////////////////////////////////////////////////////////////
// this function removes the active tab, with CTRL-W / COMMAND-W on Mac
////////////////////////////////////////////////////////////////////////////////
function removeActiveTab() {
  var mvTab = mvTabboxElement.selectedTab;
  // hack to prevent JS error, see bug 304
  var mvTabId = mvTabboxElement.selectedTab.getAttribute( "id" );

  // if ( ( mvTotalTabs > 0 ) && ( mvTabId != "Tab-0" ) ) { // keep the last tab
  if ( mvTotalTabs > 0 )  {
    removeView( mvTab );
    mvTabboxElement.removeChild( mvTab );
    mvTotalTabs--;
    // re-order id, link and viewport info!
    renumberTabs();

    // do we have a reference pointer, and we're not closing it!
    if ( mvLastActiveTab != null && mvLastActiveTab != mvTab )
      mvTab = mvLastActiveTab;
    else { // no reference, or we're about to close it!
      mvTab = mvTabboxElement.lastChild;
      mvLastActiveTab = null;
    }
    mvTabboxElement.selectedTab = mvTab;
    activateView( mvTab );

    // Open tab panel if it's hidden.
    if ( mvAutohideTabs ) {
      if ( ( !mvHiddenTabs ) && ( mvTotalTabs == 0 ) )
        toggleTabs();
    }
  }
  else 
    alert( mvCantClose );
}
////////////////////////////////////////////////////////////////////////////////
// this function removes the selected tabs, via tab context menu
////////////////////////////////////////////////////////////////////////////////
function removeTab() {
  var mvTab = null;
  // hack to prevent JS error, see bug 304
  var mvTabId = mvTabboxElement.selectedTab.getAttribute( "id" );

  if ( ( mvTotalTabs > 0 ) && ( mvTabId != "Tab-0" ) ) { // keep the last tab
    removeView( mvPopupNode );
    mvTabboxElement.removeChild( mvPopupNode );
    mvTotalTabs--;
    // re-order id, link and viewport info!
    renumberTabs();

    // do we have a reference pointer, and we're not closing it!
    if ( mvLastActiveTab != null && mvLastActiveTab != mvPopupNode )
      mvTab = mvLastActiveTab;
    else { // no reference, or we're about to close it!
      mvTab = mvTabboxElement.lastChild;
      mvLastActiveTab = null;
    }
    mvTabboxElement.selectedTab = mvTab;
    activateView( mvTab );

    // Open tab panel if it's hidden.
    if ( mvAutohideTabs ) {
      if ( ( !mvHiddenTabs ) && ( mvTotalTabs == 0 ) )
        toggleTabs();
    }
  }
  else
    alert( mvCantClose );
}
////////////////////////////////////////////////////////////////////////////////
// this function removes all tabs, but one
////////////////////////////////////////////////////////////////////////////////
function removeAllTabs() {
  var mvTabArray = new Array();

  for ( var v = 0; v <= mvTotalTabs; v++ ) {
    mvTabArray[ v ] = mvTabboxElement.childNodes[ v ];
  }
  v--;
  while ( v >= 0 && mvTotalTabs > 0 ) {
    if ( mvTabArray[ v ].getAttribute( "close" ) == "true" ) {
      removeView( mvTabArray[ v ] );
      mvTabboxElement.removeChild( mvTabArray[ v ] );
      mvTotalTabs--;
    }
    v--;
  }
  // make sure we have the right number of tabs
  renumberTabs();

  mvTabboxElement.firstChild.setAttribute( "selected", "true" );
  activateView( mvTabboxElement.selectedTab );

  // Open tab panel if it's hidden.
  if ( mvAutohideTabs ) {
    if ( ( !mvHiddenTabs ) && ( mvTotalTabs == 0 ) )
      toggleTabs();
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function removes all tabs, but keeps the current one
////////////////////////////////////////////////////////////////////////////////
function removeTabsKeepCurrent() {

  while ( mvTotalTabs > 0 ) {
    if ( mvPopupNode == mvTabboxElement.lastChild ) {
      removeView( mvTabboxElement.firstChild );
      mvTabboxElement.removeChild( mvTabboxElement.firstChild );
      mvTotalTabs--;
    }
    else {
      removeView ( mvTabboxElement.lastChild );
      mvTabboxElement.removeChild( mvTabboxElement.lastChild );
      mvTotalTabs--;
    }
  }
  renumberTabs();

 mvTabboxElement.firstChild.setAttribute( "selected", "true" );
 activateView( mvTabboxElement.selectedTab );

  // Open tab panel if it's hidden.
  if ( mvAutohideTabs ) {
    if ( ( !mvHiddenTabs ) && ( mvTotalTabs == 0 ) )
      toggleTabs();
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function re-orders tab id, link and viewport info
////////////////////////////////////////////////////////////////////////////////
function renumberTabs() {
  var v = 0;
  var url = null;
  var tabId = null;
  var viewId = null;
  var leafName = null;
  var shortURL = null;
  var newTooltipText = null;

  do {
    tabId = "Tab-" + v;
    viewId = "View-" + v;
    mvTabboxElement.childNodes[ v ].setAttribute( "id", tabId );
    mvTabboxElement.childNodes[ v ].setAttribute( "link", viewId );
    mvTabboxElement.childNodes[ v ].setAttribute( "viewport", v );
    mvDeckElement.childNodes[ v ].setAttribute( "id", viewId );
    url = mvDeckElement.childNodes[ v ].webNavigation.currentURI.spec;
    leafName = url.replace(/[&\?].*/,'').replace(/.*[:\/]/,'')

    if ( leafName == "" )
      leafName = "index.html";

    shortURL = defineShortURL( url );
    tabId = "Tab-" + ( v + 1 );
    newTooltipText = tabId + ' - ' + shortURL + ' - ' + leafName;
    mvTabboxElement.childNodes[ v ].setAttribute( "tooltiptext", newTooltipText );
    mvLinkList[ v ] = url;
    v++;
  } while ( v < mvTabboxElement.childNodes.length );

  // disable 'Go' menu options
  setGoMenuOptions();
  // disable Tab contextmenu options
  setGoMenuOptions( true );
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes the tab contextmenu
////////////////////////////////////////////////////////////////////////////////
function activateTab( tabChoice ) {
  var tabNumber = mvTabboxElement.selectedTab.getAttribute( "viewport" );
  var activatedTab = tabNumber;

  // XXX TODO: 
  // we can also use this "advanceSelectedTab( dir )" where 1 = next -1 is prior
  // can use a hidden tabpanel for this? Does it change the deck index also?
  switch ( tabChoice ) {
    case 'first': mvTabboxElement.selectedTab = mvTabboxElement.firstChild;
                  activateView( mvTabboxElement.firstChild );
                  break;
    case 'next' : if ( tabNumber < mvTotalTabs ) {
                    activatedTab++;
                    mvTabboxElement.selectedTab = document.getElementById( "Tab-" + activatedTab );
                    activateView( mvTabboxElement.selectedTab );
                  }
                  else if ( tabNumber == mvTotalTabs ) {
                    mvTabboxElement.selectedTab = mvTabboxElement.firstChild;
                    activateView( mvTabboxElement.firstChild );
                  }
                  break;
    case 'prior':  if ( tabNumber > 0 ) {
                     activatedTab--;
                     mvTabboxElement.selectedTab = document.getElementById( "Tab-" + activatedTab );
                     activateView( mvTabboxElement.selectedTab );
                   }
                   else if ( tabNumber == 0 ) {
                     mvTabboxElement.selectedTab = mvTabboxElement.lastChild;
                     activateView( mvTabboxElement.lastChild );
                   }
                  break;
    case 'last' : mvTabboxElement.selectedTab = mvTabboxElement.lastChild;
                  activateView( mvTabboxElement.lastChild );
                  break;
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function sets the tab property hidden to true/false
////////////////////////////////////////////////////////////////////////////////
function setTabProperty( top, bottom ) {

  document.getElementById( "TabBoxTop-0" ).setAttribute( "hidden", top );
  document.getElementById( "TabBoxTop-1" ).setAttribute( "hidden", top );
  document.getElementById( "TabBoxTop-2" ).setAttribute( "hidden", top );
  document.getElementById( "TabBoxBottom-0" ).setAttribute( "hidden", bottom );
  document.getElementById( "TabBoxBottom-1" ).setAttribute( "hidden", bottom );
  document.getElementById( "TabBoxBottom-2" ).setAttribute( "hidden", bottom );
}
////////////////////////////////////////////////////////////////////////////////
// this function copy the tabs from multiviewTabBox to the new tabbox
////////////////////////////////////////////////////////////////////////////////
function copyTabs( from, to ) {

  var fromTabboxElement = document.getElementById( from );
  var toTabboxElement = document.getElementById( to );

  if ( fromTabboxElement == null || toTabboxElement == null ) 
    dump( 'Error: in function copyTabs()' );

  while ( fromTabboxElement.hasChildNodes() ) {
    toTabboxElement.appendChild( fromTabboxElement.firstChild );

    if ( mvTopTabs )
      toTabboxElement.lastChild.setAttribute( "class", "tab-bottom" );
    else
      toTabboxElement.lastChild.setAttribute( "class", "tab" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function 'hides' the selected tab from Close All
////////////////////////////////////////////////////////////////////////////////
function hideTab() {

  if ( mvPopupNode.getAttribute( "close" ) == "true" )
    mvPopupNode.setAttribute( "close", "false" );
  else mvPopupNode.setAttribute( "close", "true" );
}
////////////////////////////////////////////////////////////////////////////////
// this function 'lock/unlock' the selected tab (set/unset lock on tab)
////////////////////////////////////////////////////////////////////////////////
function lockTab() {

  // if ( mvPopupNode == null ) // there's no popupNode, so use selectedTab
  mvPopupNode = mvTabboxElement.selectedTab;

  if ( mvPopupNode.getAttribute( "locked" ) == "true" ) {
    mvPopupNode.setAttribute( "locked", "false" );

    if ( mvTopTabs )
      mvPopupNode.setAttribute( "class", "tab" );
    else
      mvPopupNode.setAttribute( "class", "tab-bottom" );
  }
  else {
    mvPopupNode.setAttribute( "locked", "true" );

    if ( mvTopTabs )
      mvPopupNode.setAttribute( "class", "tab tab-locked" );
    else
      mvPopupNode.setAttribute( "class", "tab-bottom tab-locked" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function loads the 'home/start' page for the tab
////////////////////////////////////////////////////////////////////////////////
function tabHome() {
  var mvViewLink = mvPopupNode.getAttribute( "link" );
  var mvStartLocation = document.getElementById( mvViewLink ).getAttribute( "home" );
  var mvCurrentLocation = getCurrentContentURI();
	
  if ( mvCurrentLocation != "about:blank" && mvStartLocation != mvCurrentLocation )
    loadViewURI( mvStartLocation );
}
////////////////////////////////////////////////////////////////////////////////
// this function opens a new tab, or activates an already opened tab
////////////////////////////////////////////////////////////////////////////////
function openNewTabLocation( url ) {

  // make sure we have an url, and if not then:
	// will bookmark manager and add bookmark open a new tab
  if ( url == "" )
    return;
  // Open tab panel if it's hidden.
  if ( mvHiddenTabs )
    toggleTabs();

  // check preference setting
  if ( mvPreventDouble ) {
    var mvTab = getViewByURL( url );

    if ( mvTab != null ) {
      activateView( mvTab );
      mvTabboxElement.selectedTab = mvTab; 
      return;
    }
  }
  // open url in new tab
  mvNewTabURI = url;
  addNewBlank( CONTEXT );
 return;
}
////////////////////////////////////////////////////////////////////////////////
// this function spawns the "Close All - Keep List" dialog
////////////////////////////////////////////////////////////////////////////////
function closeAllTabsDialog() {
  var tabList = new Array(); // list of tabs to pass to dialog

  for ( var i = 0; i < mvTabboxElement.childNodes.length; i++ ) {
    var tabTab = new Object();
    var tabId = "View-"+i;
    tabTab.name = mvTabboxElement.childNodes[ i ].getAttribute( "label" );
    tabTab.URI = document.getElementById( tabId ).webNavigation.currentURI.spec;
    tabTab.closable = mvTabboxElement.childNodes[ i ].getAttribute( "close" );
    tabTab.closeMe = "false";
    tabList[ i ] = tabTab;
  }
  window.openDialog( "chrome://multiviews/content/multiviewsClose.xul",
   "multiviewsClose", "chrome,dependent,modal,dialog,resizable",tabList );

  try {
    // Remove the selected tabs
    // adapted from removeAllTabs() above

    var mvTabArray = new Array();
    var noCurr = false; // set to true if we remove current tab
    for ( var v = 0; v <= mvTotalTabs; v++ ) {
      mvTabArray[ v ] = mvTabboxElement.childNodes[ v ];
    }
    v--;
    while ( v >= 0 ) {
      if ( ( tabList[ v ].closeMe == "true" ) && ( mvTabArray[ v ].getAttribute( "close" ) == "true" ) ) {
        if ( mvTotalTabs > 0 ) { // this was set to 1
          if ( !noCurr && mvTabArray[ v ] == mvTabboxElement.selectedTab )
            noCurr = true;
            removeView( mvTabArray[ v ] );
            // remove the corresponding tab
            mvTabboxElement.removeChild( mvTabArray[ v ] );
            mvTotalTabs--;
        }
        else {
          alert( mvCantClose );
          break;
        }
      }
      v--;
    }
  } catch(e) { dump( e ); }

    // make sure we have the right number of tabs
    renumberTabs();

  if ( noCurr ) // If we removed current tab, set a new one
    mvTabboxElement.selectedTab = mvTabboxElement.firstChild;
  mvTabboxElement.selectedTab.setAttribute( "selected", "true" );
  activateView( mvTabboxElement.selectedTab );

  // Open tab panel if it's hidden.
  if ( mvAutohideTabs ) {
    if ( ( !mvHiddenTabs ) && ( mvTotalTabs == 0 ) )
      toggleTabs();
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function hide/shows the tabs on our deck and changes the button state
////////////////////////////////////////////////////////////////////////////////
function toggleTabs() {
  var mvTabboxIdA = new Array( 'TabBoxBottom-0', 'TabBoxTop-0' );
  var mvTabboxIdB = new Array( 'TabBoxBottom-1', 'TabBoxTop-1' );
  var mvTabboxIdC = new Array( 'TabBoxBottom-2', 'TabBoxTop-2' );
  var mvIndex = mvTopTabs ? 1 : 0; // index to select tabs

  if ( mvHiddenTabs ) { //  make tabs visual if they are hidden now
    document.getElementById( mvTabboxIdA[ mvIndex ] ).removeAttribute( "hidden" );
    document.getElementById( mvTabboxIdB[ mvIndex ] ).removeAttribute( "hidden" );
    document.getElementById( mvTabboxIdC[ mvIndex ] ).removeAttribute( "hidden" );
    mvHiddenTabs = false;
  }
  else { // hide all visual tabs
    document.getElementById( mvTabboxIdA[ mvIndex ] ).setAttribute( "hidden", "true" );
    document.getElementById( mvTabboxIdB[ mvIndex ] ).setAttribute( "hidden", "true" );
    document.getElementById( mvTabboxIdC[ mvIndex ] ).setAttribute( "hidden", "true" );
    mvHiddenTabs = true;
  }
  toggleShowHideButton();
  toggleOpenNewButton();

	// deactivate MultiZilla Toolbar
  if ( mvSecretGarden ) {
    document.getElementById( "MultiZillaToolbar" ).setAttribute( "hidden", "true" );
    document.getElementById( "cmd_viewMultiZillaToolbar" ).removeAttribute( "checked" );
    mvSecretGarden = false;
  }
  else {
    document.getElementById( "MultiZillaToolbar" ).removeAttribute( "hidden" );
    document.getElementById( "cmd_viewMultiZillaToolbar" ).setAttribute( "checked", "true" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function switches the tabs orientation by CTRL-PAGE-UP/CTRL-PAGE-DOWN
////////////////////////////////////////////////////////////////////////////////
function switchTabsTo( orientation ) {

  if ( ( orientation == 'top' ) && ( mvTopTabs == false ) )
    switchTabPosition();
  if ( ( orientation == 'bottom' ) && ( mvTopTabs == true ) )
    switchTabPosition();
}
////////////////////////////////////////////////////////////////////////////////
// this function cuts labels of tabs off, when there's no room to open a new tab
////////////////////////////////////////////////////////////////////////////////
function cutTabLabels() {
var mvTabLabels = new Array();
var mvNewLabel = null;
var i = 0;

  // Make sure we need to do this only once, saves some extra time
  for ( i = 0; i <= mvTotalTabs; i++ )
    mvTabLabels[ i ] = mvTabboxElement.childNodes[ i ].label;

    // does the new tab fit in the deck's width?
    while ( mvTabboxElement.boxObject.width == mvDeckElement.boxObject.width ) { // mvDeckElement.boxObject.width )
      mvMaxStickyLen -= 1;
      mvNewMaxStickyLen = mvMaxStickyLen -= 3;

      for ( i = 0; i <= mvTotalTabs; i++ ) {
        mvNewLabel = mvTabLabels[ i ].substr( 0, mvNewMaxStickyLen ) + "...";
        mvTabboxElement.childNodes[ i ].label = mvNewLabel;
      }
    }
}

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: Views
//
////////////////////////////////////////////////////////////////////////////////
// this function adds a view and sets the url to about:blank
////////////////////////////////////////////////////////////////////////////////
function addView() {
  var mvNewBrowser = document.createElement( "browser" );

  mvNewBrowser.setAttribute( "id", "View-" + mvTotalTabs );
  mvNewBrowser.setAttribute( "type", "content-primary" );
  mvNewBrowser.setAttribute( "src", "about:blank" );
  mvNewBrowser.setAttribute( "flex", "1" );
  mvNewBrowser.setAttribute( "tooltip", "aHTMLTooltip" );
  mvNewBrowser.setAttribute( "context", "contentAreaContextMenu" );
  mvNewBrowser.setAttribute( "onclick", "return contentAreaClick( event )" );
  mvNewBrowser.setAttribute( "ondraggesture", "nsDragAndDrop.startDrag( event, contentAreaDNDObserver )" );
  mvDeckElement.appendChild( mvNewBrowser );
  setSecurityButton();
}
////////////////////////////////////////////////////////////////////////////////
// this function activates the selected view
////////////////////////////////////////////////////////////////////////////////
function activateView( obj ) {
  var mvViewPort = obj.getAttribute( "viewport" );
  mvSelectedTab = mvViewPort;
  var mvLocation = null;

  if ( mvViewPort == "" )
    mvViewPort = 0; // switch/activate to default view
  mvDeckElement.setAttribute( "index", mvViewPort );
  

  try {
    // var mvLocation = getBrowser().contentDocument.location.href;
    var mvLocation = getSelectedContentArea().contentDocument.location.href;
    updateContentTitle();
    updateURLBar( mvLinkList[ mvSelectedTab ] );
    UpdateBackForwardButtons();
  }
  catch( e ) { }

  refreshSecurityLock();
}
////////////////////////////////////////////////////////////////////////////////
// this function reloads the view, the one you right clicked
////////////////////////////////////////////////////////////////////////////////
function reloadCurrentView() {
  var mvViewLink = mvPopupNode.getAttribute( "link" );
  var mvView = document.getElementById( mvViewLink );
  // TODO: Check if this updates Session History
  loadViewURI( getCurrentContentURI() );
}
////////////////////////////////////////////////////////////////////////////////
// this function removes the View <browser> for the given tab
////////////////////////////////////////////////////////////////////////////////
function removeView( mvTab ) {

  try {
    mvDeckElement.removeChild( document.getElementById( mvTab.getAttribute( "link" ) ) );
  }
  catch( e ) {
    dump( cantRemoveView ); // you can see this message on the console
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the view corresponding to the given URL
////////////////////////////////////////////////////////////////////////////////
function getViewByURL( url ) {
  var mvTabId = checkStoredURL( url );

  if ( mvTabId != -1 )
    return ( document.getElementById( "Tab-" + mvTabId ) );

 return ( null );
}

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: StickyName
//
////////////////////////////////////////////////////////////////////////////////
// this function set the given StickyName
////////////////////////////////////////////////////////////////////////////////
function setStickyName() {
  var mvOldStickyName = null;
  var mvNewStickyName = null;
	
  if ( mvTitleSticky )
    mvOldStickyName = getBrowser().contentDocument.title;
  else mvOldStickyName = mvPopupNode.getAttribute( "label" );

  mvNewStickyName = prompt( mvStickyLabel, mvOldStickyName );

  if ( mvNewStickyName == null )
    mvNewStickyName = mvOldStickyName;

  if ( mvNewStickyName.length > mvMaxStickyLen )
    mvNewStickyName = mvNewStickyName.substr( 0, ( mvMaxStickyLen - 3 ) ) + "...";

  mvPopupNode.setAttribute( "label", mvNewStickyName );
  mvPopupNode.setAttribute( "stickyname", "true" );
}
////////////////////////////////////////////////////////////////////////////////
// this function clears the sticky name
////////////////////////////////////////////////////////////////////////////////
function clearStickyName() {

  mvPopupNode.setAttribute( "stickyname", "false" );

  if ( mvLabelStickyPref ) 
    mvPopupNode.setAttribute( "label", mvBlankLabel );
  else
    updateTabLocation();
}
////////////////////////////////////////////////////////////////////////////////
// this function sets/clears the stickyname
////////////////////////////////////////////////////////////////////////////////
function toggleStickyName() {
  var mvActiveTab = mvTabboxElement.selectedTab;
  var mvOldStickyName = mvActiveTab.getAttribute( "label" );
  var mvNewStickyName = null;

  if ( mvActiveTab.getAttribute( "stickyname" ) == "false" ) {

    if ( mvTitleSticky )
      mvOldStickyName = getBrowser().contentDocument.title;
    mvNewStickyName = prompt( mvStickyLabel, mvOldStickyName );

    if ( mvNewStickyName == null ) // in case of cancel
      mvNewStickyName = mvOldStickyName;

    if ( mvNewStickyName.length > mvMaxStickyLen )
      mvNewStickyName = mvNewStickyName.substr( 0, ( mvMaxStickyLen - 3 ) ) + "...";

      mvActiveTab.setAttribute( "label", mvNewStickyName );
      mvActiveTab.setAttribute( "stickyname", "true" );
  }
  else {
    mvActiveTab.setAttribute( "stickyname", "false" );
    updateTabLocation();
  }
}

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: Update
//
////////////////////////////////////////////////////////////////////////////////
// this function updates the URLbar with the given URL
////////////////////////////////////////////////////////////////////////////////
function updateURLBar( mvUrl ) {
  if ( mvUrl && mvUrl != "about:blank" )
    mvUrlBar.value = mvUrl;
  else mvUrlBar.value = "";
}
////////////////////////////////////////////////////////////////////////////////
// this function updates the content title
////////////////////////////////////////////////////////////////////////////////
function updateContentTitle() {

  /* if ( !mvTitleHold ) { */
    try {
      var mvViewTitle = getBrowser().contentDocument.title;
      getCurrentContentDocument().title = mvViewTitle;
    }
    catch( e ) {} // die silently
  /* }
  else
    getCurrentContentDocument().title = 'test'; */
}
////////////////////////////////////////////////////////////////////////////////
// this function updates the tab location description
////////////////////////////////////////////////////////////////////////////////
function updateTabLocation() {
  var mvUrl = getCurrentContentURI();
  var mvNewStickyName = null;
  var mvStickySet = mvTabboxElement.selectedTab.getAttribute( "stickyname" );
  
  if ( mvStickySet == "false" ) { // no sticky name set
    /* mvNewStickyName = defineShortURL( mvUrl );

    if ( mvNewStickyName.length > mvMaxStickyLen )
      mvNewStickyName = mvNewStickyName.substr( 0, ( mvMaxStickyLen - 3 ) ) + "...";

    mvTabboxElement.selectedTab.setAttribute( "label", mvNewStickyName ); */
    setTimeout( "checkForTitleOnTab()", 25 );
  }
  updateContentTitle();
  storeURL( mvUrl );
  setTimeout( "updateTooltip()", 25 );
  setSecurityLock();

  // if ( ( mvStickySet ) && ( mvTitleSticky ) )
  //setTimeout( "checkForTitleOnTab()", 0 ); removed for non flashing tabs
  // checkForTitleOnTab();
}
////////////////////////////////////////////////////////////////////////////////
// this function updates the tab Tooltip description
////////////////////////////////////////////////////////////////////////////////
function updateTooltip() {
  var url = getCurrentContentURI();
  var shortURL = defineShortURL( url );
  // thanks to Neil Parkway <neil@parkwaycc.co.uk>
  leafName = url.replace(/[&\?].*/,'').replace(/.*[:\/]/,'')

  if (leafName == "" )
    leafName = "index.html";

  if ( mvDevTooltips ) {
    var viewportNr = mvTabboxElement.selectedTab.getAttribute( "viewport" );
    viewportNr++;
    var newTooltipText = 'Tab-' + viewportNr + ' - ' + shortURL + ' - ' + leafName;
  }
	else
   var newTooltipText = getBrowser().contentDocument.title; 
  mvTabboxElement.selectedTab.setAttribute( "tooltiptext", newTooltipText );
}
////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: URL's
//
////////////////////////////////////////////////////////////////////////////////
// this function loads the given URL after a short delay (mvLoadDelay)
////////////////////////////////////////////////////////////////////////////////
function loadViewURI( mvURL ) {
  // why in the world do we need this delay?
  setTimeout( "loadURI('"+mvURL+"')", mvLoadDelay );
}
////////////////////////////////////////////////////////////////////////////////
// this function loads an URI and updates stickyName
////////////////////////////////////////////////////////////////////////////////
function loadNewURI() {
  // TODO: we need make our own dialog for this
  BrowserOpenWindow();
  var mvLink = mvTabboxElement.selectedTab.getAttribute( "link" );
  var currentURL = getCurrentContentURI();
  document.getElementById(mvLink).setAttribute( "home", currentURL );
  // updateTabLocation();
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the current URL
////////////////////////////////////////////////////////////////////////////////
function getCurrentContentURI() {
  try {
    return getWebNavigation().currentURI.spec;
  } catch ( e ) {
    return mvHomePage;
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function displays the url in the status region of the active window
////////////////////////////////////////////////////////////////////////////////
function showUrl( event ) {
  var viewLink = event.target.getAttribute( "link" );
  window.status = document.getElementById( viewLink ).contentDocument.location.href;

  return true;
}
////////////////////////////////////////////////////////////////////////////////
// this returns a short URL from the given url, used for stickyName
////////////////////////////////////////////////////////////////////////////////
function defineShortURL( mvUrl ) {
  var mvStart = 0;
  var mvEnd = 0;

  if ( mvUrl.search( "about:blank" ) >= 0 )
    return	( "blank" );
  else if ( mvUrl.search( "http://" ) >= 0 )
    mvStart = 7;
  else if ( mvUrl.search( "https://" ) >= 0 )
    mvStart = 8;
  else if ( mvUrl.search( "ftp://" ) >= 0 )
    mvStart = 6;
  else if ( mvUrl.search( "file:///" ) >= 0 )
    return( 'file:' + mvUrl.replace(/[&\?].*/,'').replace(/.*[:\/]/,'') );
  else if ( mvUrl.search( "chrome://" ) >= 0 )
    return( 'chrome:' + mvUrl.replace(/[&\?].*/,'').replace(/.*[:\/]/,'') );

  // TODO: change this because for example 'foo.barwww.com' won't work
  if ( mvUrl.search( "www" ) >= 0 )
    mvStart += 4;
  mvUrl = mvUrl.substr( mvStart, mvMaxStickyLen );
  mvEnd = mvUrl.search( "/" );

  if ( mvEnd >= 0 )
    mvUrl = mvUrl.substr( 0, mvEnd );

  return ( mvUrl );
}
////////////////////////////////////////////////////////////////////////////////
// this function puts a part of the current title on the tab (or a shorturl)
////////////////////////////////////////////////////////////////////////////////
function checkForTitleOnTab() {
  var mvNewStickyName = null;

  if ( !mvUrlOnTab ) {
    mvNewStickyName = getBrowser().contentDocument.title;

    if( !mvNewStickyName )
      mvNewStickyName = defineShortURL( getCurrentContentURI() );

    if ( mvNewStickyName.length > mvMaxStickyLen )
      mvNewStickyName = mvNewStickyName.substr( 0, ( mvMaxStickyLen - 3 ) ) + "...";
      mvTabboxElement.selectedTab.setAttribute( "label", mvNewStickyName );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the URL read from the clipboard
////////////////////////////////////////////////////////////////////////////////
function getLocationFromClipboard()
{
  var url;

  try {
    var clipboard = Components.classes[ "@mozilla.org/widget/clipboard;1" ]
                              .getService(Components.interfaces.nsIClipboard);

    var trans = Components.classes[ "@mozilla.org/widget/transferable;1" ]
                          .createInstance(Components.interfaces.nsITransferable);

    trans.addDataFlavor( "text/unicode" );
    clipboard.getData( trans, clipboard.kGlobalClipboard );

    var data = {};
    var dataLen = {};
    trans.getTransferData( "text/unicode", data, dataLen );

    if ( data ) {
      data = data.value.QueryInterface( Components.interfaces.nsISupportsWString );
      url = data.data.substring( 0, dataLen.value / 2 );
    }
    else {
      url = 'about:blank';
      alert('Sorry, Clipboard contains no data');
    }
  } catch ( ex ) {
    alert( 'Warning: Read From Clipboard Error' );
  }
  return url;
}
////////////////////////////////////////////////////////////////////////////////
// this function stores the given url in a array
////////////////////////////////////////////////////////////////////////////////
function storeURL( url ) {
  // mvLinkList[ mvTotalTabs ] = url;
  mvLinkList[ mvSelectedTab ] = url;
}
////////////////////////////////////////////////////////////////////////////////
// this function checks if the given url is stored in mvLinkList
////////////////////////////////////////////////////////////////////////////////
function checkStoredURL( url ) {

  for ( var i = 0; i <= mvTotalTabs; i++ ) {
    if ( ( mvLinkList[ i ] == url ) || ( mvLinkList[ i ] == url + '/' ) )
      return ( i );
  }
  return ( -1 );
}

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: General functions
//
////////////////////////////////////////////////////////////////////////////////
// this function returns the content document
////////////////////////////////////////////////////////////////////////////////
function getCurrentContentDocument() {

  return getBrowser().contentDocument;
}
////////////////////////////////////////////////////////////////////////////////
// this function adds the current page to the bookmarks
////////////////////////////////////////////////////////////////////////////////
function addToBookmarks() {

  BookmarksUtils.addBookmarkForBrowser( getSelectedContentArea().webNavigation, false );
}
////////////////////////////////////////////////////////////////////////////////
// this function displays the current software version number
////////////////////////////////////////////////////////////////////////////////
function displayVersion() {
  // alert ( 'Current software version = ' + mvPrefs.Version );
  window.openDialog( "chrome://multiviews/content/multiviewsAbout.xul",
                     "multiviewsClose", "chrome, dialog, dependent", mvPrefs.Version );
}
////////////////////////////////////////////////////////////////////////////////
// this function clears the security properties for the currently selected tab
////////////////////////////////////////////////////////////////////////////////
function setSecurityButton()
{
  const ui = Components.classes[ "@mozilla.org/secure_browser_ui;1" ];
    if ( ui ) {
      var securityUI = ui.createInstance( Components.interfaces.nsISecureBrowserUI );

      if ( "gBrowser" in window ) {
        gBrowser.boxObject.setPropertyAsSupports( "xulwindow", window );
        gBrowser.boxObject.setPropertyAsSupports( "secureBrowserUI", securityUI );
      }
      var button = document.getElementById( "security-button" );

      if ( button && _content )
        securityUI.init( _content, button );
    }
}
////////////////////////////////////////////////////////////////////////////////
// this function initializes the security lock for the currently selected tab
////////////////////////////////////////////////////////////////////////////////
function setSecurityLock()
{
  var mvSecLevel = document.getElementById( "security-button" ).getAttribute( "level" );

  if ( mvSecLevel ) {
    mvSecurityLock.setAttribute( "level", mvSecLevel );
    mvTabboxElement.selectedTab.setAttribute( "level", mvSecLevel );
 }
  else {
    mvSecurityLock.removeAttribute( "level" );
    mvTabboxElement.selectedTab.removeAttribute( "level" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function sets the security lock to the current tab security state
////////////////////////////////////////////////////////////////////////////////
function refreshSecurityLock()
{
  var mvSecLevel = mvTabboxElement.selectedTab.getAttribute( "level" );

  if ( mvSecLevel )
    mvSecurityLock.setAttribute( "level", mvSecLevel );
  else mvSecurityLock.removeAttribute( "level" );
}
////////////////////////////////////////////////////////////////////////////////
// this function returns true, false or the value for the given pref setting
////////////////////////////////////////////////////////////////////////////////
function readMyPref( prefIdentifier, validOptions, defaultSetup ) {

  try {
    var mvPrefs = Components.classes[ "@mozilla.org/preferences;1" ].getService( Components.interfaces.nsIPref );
      // read the specified pref setting
      var mvMyPref = mvPrefs.CopyUnicharPref( prefIdentifier );

      // do we need to convert the value?
      if ( validOptions == "true or false" ) {
        if ( mvMyPref == "true" ) 
          return ( true );
				else return ( false );
     } // no we don't
     else if ( mvMyPref.length )
       return ( mvMyPref );
     else
        return ( defaultSetup );
  }
  catch( e ) { 
    if ( mvPrefWarning )
      alert('Warning: error reading file: all.js\n' +
            '\nMissing preference setting: ' + prefIdentifier + '\n' +
            \nValid options are: ' + validOptions );
    // return the default value for this preference setting
    return ( defaultSetup );
  }
}	
////////////////////////////////////////////////////////////////////////////////
// this function hides/shows the button in the MultiZilla toolbar
////////////////////////////////////////////////////////////////////////////////
function toggleShowHideButton() {

  if ( mvHiddenTabs ) {
    // make the hide button visual in the toolbar
    document.getElementById( "mvHideButton" ).setAttribute( "hidden", "true" );
    document.getElementById( "mvShowButton" ).removeAttribute( "hidden" );
  }
  else {
    // make the show button visual in the toolbar
    document.getElementById( "mvShowButton" ).setAttribute( "hidden", "true" );
    document.getElementById( "mvHideButton" ).removeAttribute( "hidden" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// I like to group those two functions
////////////////////////////////////////////////////////////////////////////////
function toggleOpenNewButton() {

  if ( mvHiddenTabs ) {
    // remove the Open and insert the New button in the toolbar
    document.getElementById( "mvNewButton" ).setAttribute( "hidden", "true" );
    document.getElementById( "mvOpenButton" ).removeAttribute( "hidden" );
  }
  else {
    document.getElementById( "mvOpenButton" ).setAttribute( "hidden", "true" );
    document.getElementById( "mvNewButton" ).removeAttribute( "hidden" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function checks the website for a new update of MultiZilla
////////////////////////////////////////////////////////////////////////////////
function doCheck4Updates() {
  // add current version number to url and activate the url
  openNewTabLocation('http://multizilla.mozdev.org/update.html?version=' + mvVersion);
}
////////////////////////////////////////////////////////////////////////////////
// this function 
////////////////////////////////////////////////////////////////////////////////
function getBrowser()
{
  if (gBrowser != getSelectedContentArea())
    gBrowser = getSelectedContentArea();

  return gBrowser;
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the selectedContentArea
////////////////////////////////////////////////////////////////////////////////
function getSelectedContentArea()
{
  var selectedContentArea = null;
	var viewLink = null;

  try {
    viewLink = document.getElementById("multiviewTabBox").selectedTab.getAttribute("link");
    selectedContentArea = document.getElementById(viewLink);
  }
  catch(ex) {}
	
  if (selectedContentArea == null)
    selectedContentArea = document.getElementById("content");

  return (selectedContentArea);
}

////////////////////////////////////////////////////////////////////////////////
//
// Block with functions related to: MultiZilla shutdown
//
////////////////////////////////////////////////////////////////////////////////
// this function handles the ShutDown stuff
////////////////////////////////////////////////////////////////////////////////
function mvShutdown() {
  // unregister us as a pref listener
  pref.removeObserver( window.buttonPrefListener.domain, window.buttonPrefListener );
  // window.browserContentListener.close();
}
////////////////////////////////////////////////////////////////////////////////
//  this function is called from multiviewsOverlays.xul
////////////////////////////////////////////////////////////////////////////////
function Test() {
  // alert('This is my little test function');
}

var tabDNDObserver = {
  onDragStart: function (aEvent, aXferData, aDragAction)
    {
      if (navigator.platform != "Win32" && aEvent.target.localName != "tab")
        return;

      var url = getCurrentContentURI();
      aXferData.data = new TransferData();
      aXferData.data.addDataForFlavour( "text/x-moz-url", url );
    },
  onDragOver: function( aEvent, aFlavour, aDragSession )
    {
      mvTabboxElement.selectedTab = aEvent.target;
      activateView( aEvent.target );
      aEvent.target.setAttribute( "dragover", "true" );
      return true;
    },
  onDragExit: function ( aEvent, aDragSession )
    {
      aEvent.target.removeAttribute( "dragover" );
    },
  onDrop: function ( aEvent, aXferData, aDragSession )
    {
      var url = retrieveURLFromData( aXferData.data, aXferData.flavour.contentType );
      if ( url )
        loadURI( url );
    },
  getSupportedFlavours: function ()
    {
      var flavourSet = new FlavourSet();
      flavourSet.appendFlavour( "application/x-moz-file", "nsIFile" );
      flavourSet.appendFlavour( "text/x-moz-url" );
      flavourSet.appendFlavour( "text/unicode" );
      return flavourSet;
    }
};
