/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.EnumSet;
import org.apache.aries.subsystem.core.internal.AbstractAction;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.osgi.service.subsystem.Subsystem;

public class UninstallAction
extends AbstractAction {
    public UninstallAction(BasicSubsystem requestor, BasicSubsystem target, boolean disableRootCheck) {
        super(requestor, target, disableRootCheck);
    }

    @Override
    public Object run() {
        this.checkValid();
        this.checkRoot();
        Subsystem.State state = this.target.getState();
        if (EnumSet.of(Subsystem.State.UNINSTALLED).contains(state)) {
            return null;
        }
        if (EnumSet.of(Subsystem.State.INSTALL_FAILED, new Subsystem.State[]{Subsystem.State.INSTALLING, Subsystem.State.RESOLVING, Subsystem.State.STARTING, Subsystem.State.STOPPING, Subsystem.State.UNINSTALLING}).contains(state)) {
            this.waitForStateChange();
            this.target.uninstall();
        } else if (state.equals((Object)Subsystem.State.ACTIVE)) {
            new StopAction(this.requestor, this.target, this.disableRootCheck).run();
            this.target.uninstall();
        } else {
            ResourceUninstaller.newInstance(this.requestor, this.target).uninstall();
        }
        return null;
    }
}

