/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl.config;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionClassConfig;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionConstructorConfig;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionFieldConfig;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionMethodConfig;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionConstructorConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionFieldConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionMethodConfiguration;

public class DefaultReflectionClassConfiguration
implements ReflectionClassConfig {
    public static Comparator<ReflectionConstructorConfig> cc = (o1, o2) -> {
        String s1 = o1.getMethodParameterTypes() == null ? "" : Stream.of(o1.getMethodParameterTypes()).collect(Collectors.joining(","));
        String s2 = o2.getMethodParameterTypes() == null ? "" : Stream.of(o2.getMethodParameterTypes()).collect(Collectors.joining(","));
        return s1.compareTo(s2);
    };
    public static Comparator<ReflectionFieldConfig> fc = (o1, o2) -> o1.getFieldName().compareTo(o2.getFieldName());
    public static Comparator<ReflectionMethodConfig> mc = (o1, o2) -> {
        int i = o1.getName().compareTo(o2.getName());
        if (i == 0) {
            return cc.compare((ReflectionConstructorConfig)o1, (ReflectionConstructorConfig)o2);
        }
        return i;
    };
    private boolean allPublicConstructors = false;
    private boolean allPublicFields = false;
    private boolean allPublicMethods = false;
    String className;
    private final Set<DefaultReflectionConstructorConfiguration> constructor = new TreeSet<ReflectionConstructorConfig>(cc);
    private final Set<DefaultReflectionFieldConfiguration> fields = new TreeSet<ReflectionFieldConfig>(fc);
    private final Set<DefaultReflectionMethodConfiguration> methods = new TreeSet<ReflectionMethodConfig>(mc);

    private DefaultReflectionClassConfiguration() {
    }

    public DefaultReflectionClassConfiguration(String className) {
        this();
        this.className = className;
    }

    public void add(DefaultReflectionConstructorConfiguration constructorConfigImpl) {
        this.constructor.add(constructorConfigImpl);
    }

    public void add(DefaultReflectionFieldConfiguration fieldConfigImpl) {
        this.fields.add(fieldConfigImpl);
    }

    public void add(DefaultReflectionMethodConfiguration methodConfigImpl) {
        this.methods.add(methodConfigImpl);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultReflectionClassConfiguration other = (DefaultReflectionClassConfiguration)obj;
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    public String getClassName() {
        return this.className;
    }

    public Set<ReflectionConstructorConfig> getConstructors() {
        return Set.copyOf(this.constructor);
    }

    public Set<ReflectionFieldConfig> getFields() {
        return Set.copyOf(this.fields);
    }

    public Set<ReflectionMethodConfig> getMethods() {
        return Set.copyOf(this.methods);
    }

    public boolean isAllPublicConstructors() {
        return this.allPublicConstructors;
    }

    public boolean isAllPublicFields() {
        return this.allPublicFields;
    }

    public boolean isAllPublicMethods() {
        return this.allPublicMethods;
    }

    public void setAllPublicConstructors(boolean b) {
        this.allPublicConstructors = b;
    }

    public void setAllPublicFields(boolean b) {
        this.allPublicFields = b;
    }

    public void setAllPublicMethods(boolean b) {
        this.allPublicMethods = b;
    }
}

