/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.scriptconsole.internal;

import java.io.Writer;
import org.apache.felix.webconsole.plugins.scriptconsole.internal.Logger;

class LogWriter
extends Writer {
    private Logger logger;
    private final StringBuilder lineBuffer = new StringBuilder();

    public LogWriter(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        if (c == 10 || c == 13) {
            this.flush();
        } else {
            StringBuilder stringBuilder = this.lineBuffer;
            synchronized (stringBuilder) {
                this.lineBuffer.append((char)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) {
        int i = off;
        int n = 0;
        while (n < len) {
            char c = cbuf[i];
            if (c == '\n' || c == '\r') {
                int subLen = i - off;
                if (subLen > 0) {
                    StringBuilder stringBuilder = this.lineBuffer;
                    synchronized (stringBuilder) {
                        this.lineBuffer.append(cbuf, off, subLen);
                    }
                }
                this.flush();
                off = i + 1;
            }
            ++n;
            ++i;
        }
        if (off < i) {
            StringBuilder stringBuilder = this.lineBuffer;
            synchronized (stringBuilder) {
                this.lineBuffer.append(cbuf, off, i - off);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        String message;
        StringBuilder stringBuilder = this.lineBuffer;
        synchronized (stringBuilder) {
            if (this.lineBuffer.length() == 0) {
                return;
            }
            message = this.lineBuffer.toString();
            this.lineBuffer.setLength(0);
        }
        this.logger.log(1, message);
    }

    @Override
    public void close() {
        this.flush();
    }
}

