/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MeasurementToTableViewAdaptorUtils;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TreeToTableViewAdaptorOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TreeToTableViewAdaptorOperator.class);
    private final OperatorContext operatorContext;
    private final DeviceEntry currentDeviceEntry;
    private final int[] columnsIndexArray;
    private final List<ColumnSchema> columnSchemas;
    private final Operator child;
    private final IDeviceID.TreeDeviceIdColumnValueExtractor extractor;

    public TreeToTableViewAdaptorOperator(OperatorContext operatorContext, DeviceEntry deviceEntry, int[] columnIndexArray, List<ColumnSchema> columnSchemas, Operator child, IDeviceID.TreeDeviceIdColumnValueExtractor extractor) {
        this.operatorContext = operatorContext;
        this.currentDeviceEntry = deviceEntry;
        this.columnsIndexArray = columnIndexArray;
        this.columnSchemas = columnSchemas;
        this.child = child;
        this.extractor = extractor;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNext();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock measurementDataBlock = this.child.next();
        return MeasurementToTableViewAdaptorUtils.toTableBlock(measurementDataBlock, this.columnsIndexArray, this.columnSchemas, this.currentDeviceEntry, idColumnIndex -> this.getNthIdColumnValue(this.currentDeviceEntry, idColumnIndex));
    }

    private String getNthIdColumnValue(DeviceEntry deviceEntry, int idColumnIndex) {
        return (String)this.extractor.extract(deviceEntry.getDeviceID(), idColumnIndex);
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.currentDeviceEntry) + RamUsageEstimator.sizeOf((int[])this.columnsIndexArray) + RamUsageEstimator.sizeOfCollection(this.columnSchemas);
    }
}

