/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public final class MoreLists {
    public static <T> List<List<T>> listOfListsCopy(List<List<T>> lists) {
        return (List)lists.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    public static <T> List<T> filteredCopy(Iterable<T> elements, Predicate<T> predicate) {
        Objects.requireNonNull(elements, "elements is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)Streams.stream(elements).filter(predicate).collect(ImmutableList.toImmutableList());
    }

    public static <T, R> List<R> mappedCopy(Iterable<T> elements, Function<T, R> mapper) {
        Objects.requireNonNull(elements, "elements is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return (List)Streams.stream(elements).map(mapper).collect(ImmutableList.toImmutableList());
    }

    public static <T> List<T> nElements(int n, IntFunction<T> function) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be greater than or equal to zero");
        Objects.requireNonNull(function, "function is null");
        return (List)IntStream.range(0, n).mapToObj(function).collect(ImmutableList.toImmutableList());
    }

    private MoreLists() {
    }
}

