/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.library.dprofile.util.CrossCorrelation;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFACF
implements UDTF {
    private final List<Double> valueArrayList = new ArrayList<Double>();

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.valueArrayList.clear();
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0)) {
            this.valueArrayList.add(Double.NaN);
        } else {
            this.valueArrayList.add(Util.getValueAsDouble(row, 0));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        List<Double> correlationArrayList = CrossCorrelation.calculateCrossCorrelation(this.valueArrayList, this.valueArrayList);
        for (int i = 0; i < correlationArrayList.size(); ++i) {
            collector.putDouble(i, correlationArrayList.get(i));
        }
    }

    @Override
    public void beforeDestroy() {
        this.valueArrayList.clear();
    }
}

