/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;

public interface MutableFloatSet
extends MutableFloatCollection,
FloatSet {
    @Override
    public MutableFloatSet select(FloatPredicate var1);

    @Override
    public MutableFloatSet reject(FloatPredicate var1);

    @Override
    default public MutableFloatSet tap(FloatProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> var1);

    @Override
    public MutableFloatSet with(float var1);

    @Override
    public MutableFloatSet without(float var1);

    @Override
    public MutableFloatSet withAll(FloatIterable var1);

    @Override
    public MutableFloatSet withoutAll(FloatIterable var1);

    @Override
    public MutableFloatSet asUnmodifiable();

    @Override
    public MutableFloatSet asSynchronized();

    @Override
    public FloatSet freeze();

    @Override
    public ImmutableFloatSet toImmutable();

    @Override
    default public MutableFloatSet newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }

    @Override
    default public MutableFloatSet union(FloatSet set) {
        if (this.size() > set.size()) {
            return this.toSet().withAll(set);
        }
        return set.toSet().withAll(this);
    }

    @Override
    default public MutableFloatSet intersect(FloatSet set) {
        if (this.size() < set.size()) {
            return this.select(set::contains);
        }
        return set.select(this::contains, this.newEmpty());
    }

    @Override
    default public MutableFloatSet difference(FloatSet set) {
        return this.reject(set::contains);
    }

    @Override
    default public MutableFloatSet symmetricDifference(FloatSet set) {
        return set.reject(this::contains, this.difference(set));
    }
}

