/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.memory;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.MessagingException;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.mailet.Mail;

public class MemoryMailRepository
implements MailRepository {
    private final ConcurrentHashMap<MailKey, Mail> mails = new ConcurrentHashMap();

    public MailKey store(Mail mail) {
        MailKey mailKey = MailKey.forMail((Mail)mail);
        this.mails.put(mailKey, this.cloneMail(mail));
        return mailKey;
    }

    public Iterator<MailKey> list() {
        return ((ConcurrentHashMap.KeySetView)this.mails.keySet()).iterator();
    }

    public Mail retrieve(MailKey key) {
        return Optional.ofNullable(this.mails.get(key)).map(this::cloneMail).orElse(null);
    }

    public void remove(Mail mail) {
        this.remove(MailKey.forMail((Mail)mail));
    }

    public void remove(Collection<Mail> toRemove) {
        toRemove.stream().map(MailKey::forMail).forEach(this::remove);
    }

    public void remove(MailKey key) {
        this.mails.remove(key);
    }

    public long size() {
        return this.mails.size();
    }

    public void removeAll() {
        this.mails.clear();
    }

    private Mail cloneMail(Mail mail) {
        try {
            Mail newMail = mail.duplicate();
            newMail.setName(mail.getName());
            newMail.setState(mail.getState());
            return newMail;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

