/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.message.request.AppendRequest;

public class AppendCommandParser
extends AbstractImapCommandParser {
    private final Clock clock;

    public AppendCommandParser(StatusResponseFactory statusResponseFactory, Clock clock) {
        super(ImapConstants.APPEND_COMMAND, statusResponseFactory);
        this.clock = clock;
    }

    private Flags parseFlags(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        if (next == '(') {
            return request.flagList();
        }
        return new Flags();
    }

    @VisibleForTesting
    LocalDateTime parseDateTime(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        if (next == '\"') {
            return request.dateTime();
        }
        return LocalDateTime.now(this.clock);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        Flags flags = this.parseFlags(request);
        LocalDateTime datetime = this.parseDateTime(request);
        request.nextWordChar();
        try {
            Literal literal = (Literal)request.consumeLiteral((boolean)true).right;
            return new AppendRequest(mailboxName, flags, Date.from(datetime.atZone(ZoneId.systemDefault()).toInstant()), literal, tag);
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Error copying content", e);
        }
    }
}

