/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TaskState {
    CANCELED_BEFORE_STARTING("canceled_before_starting"),
    COMPLETED_SUCCESSFULLY("completed_successfully"),
    COMPLETED_WITH_ERRORS("completed_with_errors"),
    DISABLED("disabled"),
    RUNNING("running"),
    STOPPED_BY_ADMINISTRATOR("stopped_by_administrator"),
    STOPPED_BY_ERROR("stopped_by_error"),
    STOPPED_BY_SHUTDOWN("stopped_by_shutdown"),
    UNSCHEDULED("unscheduled"),
    WAITING_ON_DEPENDENCY("waiting_on_dependency"),
    WAITING_ON_START_TIME("waiting_on_start_time");

    @NotNull
    private final String name;

    private TaskState(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static TaskState forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "canceledbeforestarting": 
            case "canceled-before-starting": 
            case "canceled_before_starting": {
                return CANCELED_BEFORE_STARTING;
            }
            case "completedsuccessfully": 
            case "completed-successfully": 
            case "completed_successfully": {
                return COMPLETED_SUCCESSFULLY;
            }
            case "completedwitherrors": 
            case "completed-with-errors": 
            case "completed_with_errors": {
                return COMPLETED_WITH_ERRORS;
            }
            case "disabled": {
                return DISABLED;
            }
            case "running": {
                return RUNNING;
            }
            case "stoppedbyadministrator": 
            case "stopped-by-administrator": 
            case "stopped_by_administrator": {
                return STOPPED_BY_ADMINISTRATOR;
            }
            case "stoppedbyerror": 
            case "stopped-by-error": 
            case "stopped_by_error": {
                return STOPPED_BY_ERROR;
            }
            case "stoppedbyshutdown": 
            case "stopped-by-shutdown": 
            case "stopped_by_shutdown": {
                return STOPPED_BY_SHUTDOWN;
            }
            case "unscheduled": {
                return UNSCHEDULED;
            }
            case "waitingondependency": 
            case "waiting-on-dependency": 
            case "waiting_on_dependency": {
                return WAITING_ON_DEPENDENCY;
            }
            case "waitingonstarttime": 
            case "waiting-on-start-time": 
            case "waiting_on_start_time": {
                return WAITING_ON_START_TIME;
            }
        }
        return null;
    }

    public boolean isPending() {
        switch (this) {
            case DISABLED: 
            case UNSCHEDULED: 
            case WAITING_ON_DEPENDENCY: 
            case WAITING_ON_START_TIME: {
                return true;
            }
        }
        return false;
    }

    public boolean isRunning() {
        return this == RUNNING;
    }

    public boolean isCompleted() {
        return !this.isPending() && !this.isRunning();
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

