/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Message;
import com.datastax.driver.core.SegmentBuilder;
import com.datastax.shaded.netty.buffer.ByteBufAllocator;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.channel.ChannelOutboundHandlerAdapter;
import com.datastax.shaded.netty.channel.ChannelPromise;

class MessageToSegmentEncoder
extends ChannelOutboundHandlerAdapter {
    private final ByteBufAllocator allocator;
    private final Message.ProtocolEncoder requestEncoder;
    private SegmentBuilder segmentBuilder;

    MessageToSegmentEncoder(ByteBufAllocator allocator, Message.ProtocolEncoder requestEncoder) {
        this.allocator = allocator;
        this.requestEncoder = requestEncoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.segmentBuilder = new SegmentBuilder(ctx, this.allocator, this.requestEncoder);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Message.Request) {
            this.segmentBuilder.addRequest((Message.Request)msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.segmentBuilder.flush();
        super.flush(ctx);
    }
}

