/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.task.eventsourcing.EventSourcingTaskManager;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class DistributedTaskManagerHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("DistributedTaskManagerConsumersHealthCheck");
    public static final ComponentName COMPONENT = new ComponentName("DistributedTaskManagerConsumers");
    private final EventSourcingTaskManager taskManager;
    private final SimpleConnectionPool connectionPool;

    @Inject
    public DistributedTaskManagerHealthCheck(EventSourcingTaskManager taskManager, SimpleConnectionPool connectionPool) {
        this.taskManager = taskManager;
        this.connectionPool = connectionPool;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return this.connectionPool.getResilientConnection().map((Function)Throwing.function(connection -> {
            try (Channel channel = connection.createChannel();){
                Result result = this.check(channel);
                return result;
            }
        })).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private Result check(Channel channel) throws IOException {
        if (channel.consumerCount("taskManagerWorkQueue") == 0L) {
            this.taskManager.restart();
            return Result.degraded((ComponentName)COMPONENT, (String)"No consumers");
        }
        return Result.healthy((ComponentName)COMPONENT);
    }
}

