/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityState;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SubtreeAccessibilityRestriction
implements Serializable {
    private static final long serialVersionUID = -1893365464740536092L;
    @NotNull
    private final Date effectiveTime;
    @Nullable
    private final String bypassUserDN;
    @NotNull
    private final String subtreeBaseDN;
    @NotNull
    private final SubtreeAccessibilityState accessibilityState;

    public SubtreeAccessibilityRestriction(@NotNull String subtreeBaseDN, @NotNull SubtreeAccessibilityState accessibilityState, @Nullable String bypassUserDN, @NotNull Date effectiveTime) {
        this.subtreeBaseDN = subtreeBaseDN;
        this.accessibilityState = accessibilityState;
        this.bypassUserDN = bypassUserDN;
        this.effectiveTime = effectiveTime;
    }

    @NotNull
    public String getSubtreeBaseDN() {
        return this.subtreeBaseDN;
    }

    @NotNull
    public SubtreeAccessibilityState getAccessibilityState() {
        return this.accessibilityState;
    }

    @Nullable
    public String getBypassUserDN() {
        return this.bypassUserDN;
    }

    @NotNull
    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SubtreeAccessibilityRestriction(base='");
        buffer.append(this.subtreeBaseDN.replace("\\\"", "\\22"));
        buffer.append("', state='");
        buffer.append(this.accessibilityState.getStateName());
        buffer.append('\'');
        if (this.bypassUserDN != null) {
            buffer.append(", bypassUser='");
            buffer.append(this.bypassUserDN.replace("\\\"", "\\22"));
            buffer.append('\'');
        }
        buffer.append(", effectiveTime='");
        buffer.append(StaticUtils.encodeGeneralizedTime(this.effectiveTime));
        buffer.append("')");
    }
}

