/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ValuePatch<T> {
    private final T value;
    private final State state;

    public static <T> ValuePatch<T> modifyTo(T value) {
        Preconditions.checkNotNull(value);
        return new ValuePatch<T>(value, State.MODIFY);
    }

    public static <T> ValuePatch<T> ofNullable(T value) {
        return ValuePatch.ofOptional(Optional.ofNullable(value));
    }

    public static <T> ValuePatch<T> ofOptional(Optional<T> value) {
        Preconditions.checkNotNull(value);
        return value.map(ValuePatch::modifyTo).orElse(ValuePatch.remove());
    }

    public static <T> ValuePatch<T> remove() {
        return new ValuePatch<Object>(null, State.REMOVE);
    }

    public static <T> ValuePatch<T> keep() {
        return new ValuePatch<Object>(null, State.KEEP);
    }

    private ValuePatch(T value, State state) {
        this.value = value;
        this.state = state;
    }

    public boolean isRemoved() {
        return this.state == State.REMOVE;
    }

    public boolean isModified() {
        return this.state == State.MODIFY;
    }

    public boolean isKept() {
        return this.state == State.KEEP;
    }

    public <S> Optional<S> mapNotKeptToOptional(Function<Optional<T>, S> updateTransformation) {
        if (this.isKept()) {
            return Optional.empty();
        }
        return Optional.of(updateTransformation.apply(Optional.ofNullable(this.value)));
    }

    public T get() {
        if (this.isModified()) {
            return this.value;
        }
        throw new NoSuchElementException();
    }

    public Optional<T> notKeptOrElse(Optional<T> replacement) {
        if (this.isKept()) {
            return replacement;
        }
        return Optional.ofNullable(this.value);
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    public T getOrElse(T replacement) {
        return this.toOptional().orElse(replacement);
    }

    public ValuePatch<T> merge(ValuePatch<T> other) {
        if (this.isKept()) {
            return other;
        }
        if (other.isKept()) {
            return this;
        }
        throw new IllegalStateException("the two merged ValuePatch represent a mutation");
    }

    public boolean equals(Object o) {
        if (o instanceof ValuePatch) {
            ValuePatch that = (ValuePatch)o;
            return Objects.equals(this.value, that.value) && Objects.equals((Object)this.state, (Object)that.state);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.state});
    }

    private static enum State {
        KEEP,
        REMOVE,
        MODIFY;

    }
}

