/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.tdb2.modify;

import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.modify.UpdateEngine;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineMain;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb2.store.DatasetGraphTxn;

public class UpdateEngineTDB extends UpdateEngineMain
{
    // ---- Factory
    public static UpdateEngineFactory getFactory() {
        return new UpdateEngineFactory()
        {
            @Override
            public boolean accept(DatasetGraph dataset, Context context) {
                return (dataset instanceof DatasetGraphTxn);
            }

            @Override
            public UpdateEngine create(DatasetGraph dataset, Context context) {
                return new UpdateEngineTDB((DatasetGraphTxn)dataset, context);
            }
        };
    }

    public static void register() { UpdateEngineRegistry.get().add(getFactory()); }

    public UpdateEngineTDB(DatasetGraphTxn graphStore, Context context)
    { super(graphStore, context); }
}
