/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * Testing Element.setAttributeNodeNS: If an attribute with that local name
 * and that namespace URI is already present in the element, it is replaced
 * by the new one.
 * Create a new element and two new attribute nodes (in the same namespace
 * and same localNames).
 * Add the two new attribute nodes to the element node using the
 * setAttributeNodeNS method.  Check that only one attribute is added, check
 * the value of this attribute.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 */
public class elementsetattributenodens01 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staff", true);
        Element element = doc.createElementNS("http://www.w3.org/DOM/Test/Level2", "new:element");
        Attr attribute1 = doc.createAttributeNS("http://www.w3.org/DOM/Test/att1", "p1:att");
        Attr attribute2 = doc.createAttributeNS("http://www.w3.org/DOM/Test/att1", "p2:att");
        attribute2.setValue("value2");
        Attr newAttribute = element.setAttributeNodeNS(attribute1);
        newAttribute = element.setAttributeNodeNS(attribute2);
        Attr attrNode = element.getAttributeNodeNS("http://www.w3.org/DOM/Test/att1", "att");
        String attrName = attrNode.getNodeName();
        String attrNS = attrNode.getNamespaceURI();
        assertEquals("p2:att", attrName, "elementsetattributenodens01_attrName");
        assertEquals("http://www.w3.org/DOM/Test/att1", attrNS, "elementsetattributenodens01_attrNS");
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        assertEquals(1, length, "length");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens01";
    }

}
