/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.metrics.core.meter.invocation.AbstractInvocationMeter;
import org.apache.servicecomb.swagger.invocation.Response;

public abstract class AbstractInvocationMeters {
    protected MeterRegistry registry;
    private final Map<String, AbstractInvocationMeter> metersMap = new ConcurrentHashMapEx();
    private int maxKeyLen = 64;
    protected MetricsBootstrapConfig metricsBootstrapConfig;

    public AbstractInvocationMeters(MeterRegistry registry, MetricsBootstrapConfig metricsBootstrapConfig) {
        this.registry = registry;
        this.metricsBootstrapConfig = metricsBootstrapConfig;
    }

    protected AbstractInvocationMeter getOrCreateMeters(Invocation invocation, Response response) {
        StringBuilder keyBuilder = new StringBuilder(this.maxKeyLen);
        String invocationName = invocation.getInvocationType().name();
        keyBuilder.append(invocationName).append(invocation.getRealTransportName()).append(invocation.getMicroserviceQualifiedName()).append(response.getStatusCode());
        if (keyBuilder.length() > this.maxKeyLen) {
            this.maxKeyLen = keyBuilder.length();
        }
        return this.metersMap.computeIfAbsent(keyBuilder.toString(), k -> {
            AbstractInvocationMeter meter = this.createMeter("servicecomb.invocation", Tags.empty().and("role", invocationName).and("transport", invocation.getRealTransportName()).and("operation", invocation.getMicroserviceQualifiedName()).and("status", String.valueOf(response.getStatusCode())));
            return meter;
        });
    }

    protected abstract AbstractInvocationMeter createMeter(String var1, Tags var2);

    public void onInvocationStart(InvocationStartEvent event) {
    }

    public void onInvocationFinish(InvocationFinishEvent event) {
        AbstractInvocationMeter meters = this.getOrCreateMeters(event.getInvocation(), event.getResponse());
        meters.onInvocationFinish(event);
    }
}

