/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.OperationConfig;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowInvocationLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"scb-slow");

    public SlowInvocationLogger(SCBEngine scbEngine) {
        scbEngine.getEventBus().register((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onInvocationFinish(InvocationFinishEvent event) {
        Invocation invocation = event.getInvocation();
        OperationConfig operationConfig = invocation.getOperationMeta().getConfig();
        if (!operationConfig.isSlowInvocationEnabled() || invocation.getInvocationStageTrace().calcTotal() < operationConfig.getNanoSlowInvocation()) {
            return;
        }
        if (invocation.isProducer()) {
            SlowInvocationLogger.logSlowProvider(invocation, event.getResponse(), operationConfig);
            return;
        }
        if (invocation.isEdge()) {
            SlowInvocationLogger.logSlowEdge(invocation, event.getResponse(), operationConfig);
            return;
        }
        SlowInvocationLogger.logSlowConsumer(invocation, event.getResponse(), operationConfig);
    }

    private static String collectClientAddress(Invocation invocation) {
        HttpServletRequestEx requestEx = invocation.getRequestEx();
        return requestEx == null ? "unknown" : requestEx.getRemoteAddr() + ":" + requestEx.getRemotePort();
    }

    private static String collectTargetAddress(Invocation invocation) {
        Endpoint endpoint = invocation.getEndpoint();
        return endpoint == null ? "unknown" : endpoint.getEndpoint();
    }

    private static String formatTime(long doubleNano) {
        long micros = TimeUnit.NANOSECONDS.toMicros(doubleNano);
        return micros / 1000L + "." + micros % 1000L;
    }

    private static void logSlowProvider(Invocation invocation, Response response, OperationConfig operationConfig) {
        RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        InvocationStageTrace stageTrace = invocation.getInvocationStageTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("Slow Provider invocation [").append(invocation.getInvocationQualifiedName()).append("](").append(operationConfig.getMsSlowInvocation()).append(" ms").append(")[").append(invocation.getTraceId()).append("]\n").append(SlowInvocationLogger.formatPair("  ", "http method", restOperationMeta.getHttpMethod())).append(SlowInvocationLogger.formatPair("  ", "url", restOperationMeta.getAbsolutePath())).append(SlowInvocationLogger.formatPair("  ", "endpoint", SlowInvocationLogger.collectClientAddress(invocation))).append(SlowInvocationLogger.formatPair("  ", "status code", String.valueOf(response.getStatusCode()))).append(SlowInvocationLogger.formatPair("    ", "total", stageTrace.calcTotal())).append(SlowInvocationLogger.formatPair("    ", "prepare", stageTrace.calcPrepare())).append(SlowInvocationLogger.formatPair("    ", "provider-decode", stageTrace.calcProviderDecodeRequest())).append(SlowInvocationLogger.formatPair("    ", "queue", stageTrace.calcQueue())).append(SlowInvocationLogger.formatPair("    ", "execute", stageTrace.calcBusinessExecute())).append(SlowInvocationLogger.formatPair("    ", "provider-encode", stageTrace.calcProviderEncodeResponse())).append(SlowInvocationLogger.formatPair("    ", "provider-send", stageTrace.calcProviderSendResponse()));
        ArrayList sorted = new ArrayList(stageTrace.getStages().keySet());
        sorted.stream().sorted().forEach(key -> sb.append(SlowInvocationLogger.formatPair("    ", key, InvocationStageTrace.calc((long)((InvocationStageTrace.Stage)stageTrace.getStages().get(key)).getEndTime(), (long)((InvocationStageTrace.Stage)stageTrace.getStages().get(key)).getBeginTime()))));
        LOGGER.warn(sb.toString());
    }

    protected static String formatPair(String padding, String name, String value) {
        return String.format("%-20s: %20s\n", padding + name, value);
    }

    protected static String formatPair(String padding, String name, long time) {
        return String.format("%-20s: %8sms\n", padding + name, SlowInvocationLogger.formatTime(time));
    }

    private static void logSlowConsumer(Invocation invocation, Response response, OperationConfig operationConfig) {
        RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        InvocationStageTrace stageTrace = invocation.getInvocationStageTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("Slow Consumer invocation [").append(invocation.getInvocationQualifiedName()).append("](").append(operationConfig.getMsSlowInvocation()).append(" ms").append(")[").append(invocation.getTraceId()).append("]\n").append(SlowInvocationLogger.formatPair("  ", "http method", restOperationMeta.getHttpMethod())).append(SlowInvocationLogger.formatPair("  ", "url", restOperationMeta.getAbsolutePath())).append(SlowInvocationLogger.formatPair("  ", "endpoint", SlowInvocationLogger.collectTargetAddress(invocation))).append(SlowInvocationLogger.formatPair("  ", "status code", String.valueOf(response.getStatusCode()))).append(SlowInvocationLogger.formatPair("    ", "total", stageTrace.calcTotal())).append(SlowInvocationLogger.formatPair("    ", "prepare", stageTrace.calcPrepare())).append(SlowInvocationLogger.formatPair("    ", "connection", stageTrace.calcConnection())).append(SlowInvocationLogger.formatPair("    ", "consumer-encode", stageTrace.calcConsumerEncodeRequest())).append(SlowInvocationLogger.formatPair("    ", "consumer-send", stageTrace.calcConsumerSendRequest())).append(SlowInvocationLogger.formatPair("    ", "wait", stageTrace.calcWait())).append(SlowInvocationLogger.formatPair("    ", "consumer-decode", stageTrace.calcConsumerDecodeResponse()));
        ArrayList sorted = new ArrayList(stageTrace.getStages().keySet());
        sorted.stream().sorted().forEach(key -> sb.append(SlowInvocationLogger.formatPair("    ", key, InvocationStageTrace.calc((long)((InvocationStageTrace.Stage)stageTrace.getStages().get(key)).getEndTime(), (long)((InvocationStageTrace.Stage)stageTrace.getStages().get(key)).getBeginTime()))));
        LOGGER.warn(sb.toString());
    }

    private static void logSlowEdge(Invocation invocation, Response response, OperationConfig operationConfig) {
        RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        InvocationStageTrace stageTrace = invocation.getInvocationStageTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("Slow Edge invocation [").append(invocation.getInvocationQualifiedName()).append("](").append(operationConfig.getMsSlowInvocation()).append(" ms").append(")[").append(invocation.getTraceId()).append("]\n").append(SlowInvocationLogger.formatPair("  ", "http method", restOperationMeta.getHttpMethod())).append(SlowInvocationLogger.formatPair("  ", "url", restOperationMeta.getAbsolutePath())).append(SlowInvocationLogger.formatPair("  ", "endpoint", SlowInvocationLogger.collectTargetAddress(invocation))).append(SlowInvocationLogger.formatPair("  ", "status code", String.valueOf(response.getStatusCode()))).append(SlowInvocationLogger.formatPair("    ", "total", stageTrace.calcTotal())).append(SlowInvocationLogger.formatPair("    ", "prepare", stageTrace.calcPrepare())).append(SlowInvocationLogger.formatPair("    ", "provider-decode", stageTrace.calcProviderDecodeRequest())).append(SlowInvocationLogger.formatPair("    ", "connection", stageTrace.calcConnection())).append(SlowInvocationLogger.formatPair("    ", "consumer-encode", stageTrace.calcConsumerEncodeRequest())).append(SlowInvocationLogger.formatPair("    ", "consumer-send", stageTrace.calcConsumerSendRequest())).append(SlowInvocationLogger.formatPair("    ", "wait", stageTrace.calcWait())).append(SlowInvocationLogger.formatPair("    ", "consumer-decode", stageTrace.calcConsumerDecodeResponse())).append(SlowInvocationLogger.formatPair("    ", "provider-encode", stageTrace.calcProviderEncodeResponse())).append(SlowInvocationLogger.formatPair("    ", "provider-send", stageTrace.calcProviderSendResponse()));
        ArrayList sorted = new ArrayList(stageTrace.getStages().keySet());
        sorted.stream().sorted().forEach(key -> sb.append(SlowInvocationLogger.formatPair("    ", key, InvocationStageTrace.calc((long)((InvocationStageTrace.Stage)stageTrace.getStages().get(key)).getEndTime(), (long)((InvocationStageTrace.Stage)stageTrace.getStages().get(key)).getBeginTime()))));
        LOGGER.warn(sb.toString());
    }
}

