/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.micrometer.tagged.RateLimiterMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetrics;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableRateLimiter;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.IdentifierRateLimitingPolicy;
import org.apache.servicecomb.governance.properties.IdentifierRateLimitProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierRateLimitingHandler
extends AbstractGovernanceHandler<RateLimiter, IdentifierRateLimitingPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierRateLimitingHandler.class);
    private final IdentifierRateLimitProperties rateLimitProperties;

    public IdentifierRateLimitingHandler(IdentifierRateLimitProperties rateLimitProperties) {
        this.rateLimitProperties = rateLimitProperties;
    }

    @Override
    protected String createKey(GovernanceRequestExtractor requestExtractor, IdentifierRateLimitingPolicy policy) {
        if (StringUtils.isEmpty((CharSequence)policy.getIdentifier()) || StringUtils.isEmpty((CharSequence)requestExtractor.header(policy.getIdentifier()))) {
            LOGGER.info("identifier rate limiting is not properly configured, identifier is empty.");
            return null;
        }
        return this.rateLimitProperties.getConfigKey() + "." + policy.getName() + "." + requestExtractor.header(policy.getIdentifier());
    }

    @Override
    protected void onConfigurationChanged(String key) {
        if (key.startsWith(this.rateLimitProperties.getConfigKey())) {
            for (String processorKey : this.processors.keySet()) {
                Disposable processor;
                if (!processorKey.startsWith(key) || (processor = (Disposable)this.processors.remove(processorKey)) == null) continue;
                LOGGER.info("remove identifier rate limiting processor {}", (Object)key);
                processor.dispose();
            }
        }
    }

    @Override
    public IdentifierRateLimitingPolicy matchPolicy(GovernanceRequestExtractor requestExtractor) {
        return (IdentifierRateLimitingPolicy)this.matchersManager.match(requestExtractor, this.rateLimitProperties.getParsedEntity());
    }

    @Override
    public Disposable<RateLimiter> createProcessor(String key, GovernanceRequestExtractor requestExtractor, IdentifierRateLimitingPolicy policy) {
        return this.getRateLimiter(key, policy);
    }

    private Disposable<RateLimiter> getRateLimiter(String key, IdentifierRateLimitingPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        RateLimiterConfig config = RateLimiterConfig.custom().limitForPeriod(policy.getRate()).limitRefreshPeriod(Duration.parse(policy.getLimitRefreshPeriod())).timeoutDuration(Duration.parse(policy.getTimeoutDuration())).build();
        RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of((RateLimiterConfig)config);
        if (this.meterRegistry != null) {
            TaggedRateLimiterMetrics.ofRateLimiterRegistry((RateLimiterMetricNames)RateLimiterMetricNames.custom().availablePermissionsMetricName(this.rateLimitProperties.getConfigKey() + ".available.permissions").waitingThreadsMetricName(this.rateLimitProperties.getConfigKey() + ".waiting.threads").build(), (RateLimiterRegistry)rateLimiterRegistry).bindTo(this.meterRegistry);
        }
        return new DisposableRateLimiter(key, rateLimiterRegistry.rateLimiter(key), rateLimiterRegistry);
    }
}

