/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingValueMap
implements ValueMap {
    private static final String IMMUTABLE_ERROR_MESSAGE = "CachingValueMap is immutable";
    private final ValueMap delegate;
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private boolean fullyCached = false;

    public CachingValueMap(ValueMap delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.fullyCached ? this.cache.size() : this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key) || this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value) || this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return key instanceof String ? this.cache.computeIfAbsent((String)key, this.delegate::get) : null;
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        this.ensureFullyCached();
        return this.cache.keySet();
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        this.ensureFullyCached();
        return this.cache.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        this.ensureFullyCached();
        return this.cache.entrySet();
    }

    private void ensureFullyCached() {
        if (!this.fullyCached) {
            this.cache.putAll(this.delegate);
            this.fullyCached = true;
        }
    }

    @Override
    @Nullable
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ?> m) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }
}

