/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.installer.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.launchpad.installer.impl.LaunchpadConfigInstaller;
import org.apache.sling.launchpad.installer.impl.LaunchpadListener;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServicesListener {
    private final BundleContext bundleContext;
    private final Listener installerListener;
    private final Listener providerListener;
    private final Listener startupListener;
    private final Listener settingsListener;
    private ServiceRegistration launchpadListenerReg;
    private volatile boolean installed = false;
    private LaunchpadListener launchpadListener;

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.installerListener = new Listener(OsgiInstaller.class.getName());
        this.providerListener = new Listener(LaunchpadContentProvider.class.getName());
        this.startupListener = new Listener(StartupHandler.class.getName());
        this.settingsListener = new Listener(SlingSettingsService.class.getName());
        this.startupListener.start();
        this.installerListener.start();
        this.providerListener.start();
        this.settingsListener.start();
    }

    public synchronized void notifyChange() {
        OsgiInstaller installer = (OsgiInstaller)this.installerListener.getService();
        LaunchpadContentProvider lcp = (LaunchpadContentProvider)this.providerListener.getService();
        StartupHandler handler = (StartupHandler)this.startupListener.getService();
        SlingSettingsService settings = (SlingSettingsService)this.settingsListener.getService();
        if (installer != null && lcp != null && handler != null && settings != null && !this.installed) {
            this.installed = true;
            this.launchpadListener = new LaunchpadListener(handler);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Apache Sling Launchpad Startup Listener");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            this.launchpadListenerReg = this.bundleContext.registerService(InstallationListener.class.getName(), (Object)this.launchpadListener, props);
            LaunchpadConfigInstaller.install(installer, lcp, settings.getRunModes());
        }
    }

    public void deactivate() {
        this.installerListener.deactivate();
        this.providerListener.deactivate();
        this.startupListener.deactivate();
        this.settingsListener.deactivate();
        if (this.launchpadListenerReg != null) {
            this.launchpadListener.stop();
            this.launchpadListenerReg.unregister();
            this.launchpadListenerReg = null;
        }
        this.launchpadListener = null;
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private volatile ServiceReference reference;
        private volatile Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
            this.retainService();
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        ServicesListener.this.notifyChange();
                    }
                }
            }
        }

        private synchronized void releaseService() {
            if (this.reference != null) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                ServicesListener.this.notifyChange();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            } else if (event.getType() == 4) {
                this.releaseService();
            }
        }
    }
}

