/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.use;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.loop.EventLoopInterop;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsUtils;
import org.apache.sling.scripting.sightly.js.impl.use.DependencyResolver;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class UseFunction
extends BaseFunction {
    private final JsEnvironment jsEnvironment;
    private final DependencyResolver dependencyResolver;
    private final Scriptable thisObj;
    private final Bindings globalBindings;

    public UseFunction(JsEnvironment jsEnvironment, DependencyResolver dependencyResolver, Bindings globalBindings, Bindings arguments) {
        this.jsEnvironment = jsEnvironment;
        this.dependencyResolver = dependencyResolver;
        this.globalBindings = globalBindings;
        this.thisObj = this.createThisBinding(arguments);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        List<String> depNames;
        Function function;
        if (args.length == 0) {
            throw new IllegalArgumentException("Not enough arguments for use");
        }
        if (args.length == 1) {
            function = this.decodeCallback(args[0]);
            depNames = Collections.emptyList();
        } else {
            function = this.decodeCallback(args[1]);
            depNames = this.decodeDepNames(args[0]);
        }
        return this.use(depNames, function, cx, scope);
    }

    private Object use(List<String> depNames, Function callback, Context cx, Scriptable scope) {
        AsyncContainer asyncContainer = new AsyncContainer();
        if (depNames.isEmpty()) {
            this.callImmediate(callback, asyncContainer, cx, scope);
        } else {
            int[] counter = new int[]{depNames.size()};
            Object[] dependencies = new Object[depNames.size()];
            for (int i = 0; i < depNames.size(); ++i) {
                int dependencyPos = i;
                String dependency = depNames.get(i);
                ScriptNameAwareReader dependencyReader = this.dependencyResolver.resolve(this.globalBindings, dependency);
                if (dependencyReader == null) {
                    throw new SightlyException("Cannot locate script " + dependency);
                }
                LazyBindings bindings = new LazyBindings();
                bindings.putAll(this.globalBindings);
                bindings.put("javax.script.filename", (Object)dependencyReader.getScriptName());
                this.jsEnvironment.runScript(dependencyReader, (Bindings)bindings, Utils.EMPTY_BINDINGS, arg -> {
                    counter[0] = counter[0] - 1;
                    dependencies[dependencyPos] = arg;
                    if (counter[0] == 0) {
                        Object result = JsUtils.callFn(callback, cx, scope, this.thisObj, dependencies);
                        asyncContainer.complete(result);
                    }
                });
            }
        }
        return asyncContainer;
    }

    private void callImmediate(Function callback, AsyncContainer asyncContainer, Context cx, Scriptable scope) {
        EventLoopInterop.schedule(cx, () -> {
            Object value = JsUtils.callFn(callback, cx, scope, this.thisObj, new Object[0]);
            asyncContainer.complete(value);
        });
    }

    private Function decodeCallback(Object obj) {
        if (!(obj instanceof Function)) {
            throw new IllegalArgumentException("No callback argument supplied");
        }
        return (Function)obj;
    }

    private List<String> decodeDepNames(Object obj) {
        if (obj instanceof NativeArray) {
            return this.decodeDepArray((NativeArray)obj);
        }
        return Collections.singletonList(this.jsToString(obj));
    }

    private List<String> decodeDepArray(NativeArray nativeArray) {
        int depLength = (int)nativeArray.getLength();
        ArrayList<String> depNames = new ArrayList<String>(depLength);
        for (int i = 0; i < depLength; ++i) {
            String depName = this.jsToString(nativeArray.get(i, (Scriptable)nativeArray));
            depNames.add(depName);
        }
        return depNames;
    }

    private String jsToString(Object obj) {
        return (String)Context.jsToJava((Object)obj, String.class);
    }

    private Scriptable createThisBinding(Bindings arguments) {
        NativeObject nativeObject = new NativeObject();
        for (Map.Entry entry : arguments.entrySet()) {
            ScriptableObject.putProperty((Scriptable)nativeObject, (String)((String)entry.getKey()), entry.getValue());
        }
        return nativeObject;
    }
}

