/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.query.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Date;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(name="sling.testing.clients.query.servlet", service={Servlet.class}, property={"sling.servlet.paths=/system/testing/query", "sling.servlet.methods=GET"})
public class QueryServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/system/testing/query";
    public static final String SERVLET_NAME = "sling.testing.clients.query.servlet";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            QueryManager qm = ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getQueryManager();
            long before = 0L;
            long after = 0L;
            long total = 0L;
            String query = request.getParameter("query");
            String type = request.getParameter("type");
            boolean showResults = !"false".equalsIgnoreCase(request.getParameter("showresults"));
            String explainParam = request.getParameter("explain");
            boolean explainQuery = explainParam != null && !"false".equalsIgnoreCase(explainParam);
            boolean tidy = false;
            for (String selector : request.getRequestPathInfo().getSelectors()) {
                if (!"tidy".equals(selector)) continue;
                tidy = true;
            }
            if (query == null || query.equals("") || type == null || type.equals("")) {
                response.sendError(400, "Parameters query and type are required");
                return;
            }
            if (explainQuery) {
                query = "explain " + query;
            }
            Query q = qm.createQuery(query, type);
            before = new Date().getTime();
            QueryResult result = q.execute();
            after = new Date().getTime();
            String firstSelector = null;
            if (result.getSelectorNames().length > 1) {
                firstSelector = result.getSelectorNames()[0];
                try {
                    String firstColumnName;
                    int firstDot;
                    String[] columnNames = result.getColumnNames();
                    if (columnNames.length > 0 && (firstDot = (firstColumnName = columnNames[0]).indexOf(46)) > 0) {
                        firstSelector = firstColumnName.substring(0, firstDot);
                    }
                }
                catch (Exception columnNames) {
                    // empty catch block
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode responseJson = mapper.createObjectNode();
            if (explainQuery) {
                responseJson.put("plan", result.getRows().nextRow().getValue("plan").getString());
            } else if (showResults) {
                ArrayNode results = mapper.createArrayNode();
                RowIterator rows = result.getRows();
                while (rows.hasNext()) {
                    Row row = rows.nextRow();
                    String rowPath = firstSelector != null ? row.getPath(firstSelector) : row.getPath();
                    String rowType = firstSelector != null ? row.getNode(firstSelector).getPrimaryNodeType().getName() : row.getNode().getPrimaryNodeType().getName();
                    ObjectNode rowJson = mapper.createObjectNode();
                    rowJson.put("path", rowPath);
                    rowJson.put("type", rowType);
                    results.add((JsonNode)rowJson);
                    ++total;
                }
                responseJson.set("results", (JsonNode)results);
            } else {
                RowIterator rows = result.getRows();
                while (rows.hasNext()) {
                    rows.nextRow();
                    ++total;
                }
            }
            responseJson.put("total", total);
            responseJson.put("time", after - before);
            if (tidy) {
                response.getWriter().write(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)responseJson));
            } else {
                response.getWriter().write(responseJson.toString());
            }
        }
        catch (InvalidQueryException e) {
            response.sendError(400, e.getMessage());
            e.printStackTrace(response.getWriter());
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
            e.printStackTrace(response.getWriter());
        }
    }
}

