/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.OutputFileFormat;
import org.apache.sling.thumbnails.RenditionSupport;
import org.apache.sling.thumbnails.ThumbnailSupport;
import org.apache.sling.thumbnails.Transformation;
import org.apache.sling.thumbnails.Transformer;
import org.apache.sling.thumbnails.internal.TransformationCache;
import org.apache.sling.thumbnails.internal.TransformationServiceUser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class TransformServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TransformServlet.class);
    private static final long serialVersionUID = -1513067546618762171L;
    private final transient RenditionSupport renditionSupport;
    private final transient ServiceRegistration<Servlet> servletRegistration;
    private final transient TransformationServiceUser transformationServiceUser;
    private final transient Transformer transformer;
    private final transient ThumbnailSupport thumbnailSupport;
    private final transient TransformationCache transformationCache;

    @Activate
    public TransformServlet(@Reference ThumbnailSupport thumbnailSupport, @Reference Transformer transformer, @Reference TransformationServiceUser transformationServiceUser, @Reference TransformationCache transformationCache, @Reference RenditionSupport renditionSupport, BundleContext context) {
        this.renditionSupport = renditionSupport;
        this.thumbnailSupport = thumbnailSupport;
        this.transformer = transformer;
        this.transformationServiceUser = transformationServiceUser;
        this.transformationCache = transformationCache;
        log.info("Registering as servlet...");
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("sling.servlet.methods", new String[]{"GET"});
        ((Dictionary)properties).put("sling.servlet.extensions", "transform");
        ((Dictionary)properties).put("sling.servlet.resourceTypes", thumbnailSupport.getSupportedTypes());
        this.servletRegistration = context.registerService(Servlet.class, (Object)this, properties);
        log.info("Transform servlet registered...");
    }

    @Deactivate
    public void deactivate() {
        if (this.servletRegistration != null) {
            this.servletRegistration.unregister();
        }
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block10: {
            log.trace("doGet");
            String transformationName = StringUtils.substringBeforeLast((String)request.getRequestPathInfo().getSuffix(), (String)".");
            String renditionName = request.getRequestPathInfo().getSuffix();
            String format = StringUtils.substringAfterLast((String)request.getRequestPathInfo().getSuffix(), (String)".");
            response.setHeader("Content-Disposition", "filename=" + request.getResource().getName());
            log.debug("Transforming resource: {} with transformation: {} to {}", new Object[]{request.getResource(), transformationName, format});
            try {
                Resource file = request.getResource();
                if (this.renditionSupport.renditionExists(file, renditionName)) {
                    response.setContentType(OutputFileFormat.forRequest(request).getMimeType());
                    IOUtils.copy((InputStream)this.renditionSupport.getRenditionContent(file, renditionName), (OutputStream)response.getOutputStream());
                    break block10;
                }
                try (ResourceResolver servicResolver = this.transformationServiceUser.getTransformationServiceUser();){
                    this.performTransformation(request, response, transformationName, renditionName, servicResolver);
                }
            }
            catch (BadRequestException e) {
                log.error("Could not render thumbnail due to bad request", (Throwable)e);
                response.sendError(400, "Could not render thumbnail due to bad request: " + e.getMessage());
            }
            catch (Exception e) {
                log.error("Exception rendering transformed resource", (Throwable)e);
                response.setStatus(500);
                RequestDispatcherOptions op = new RequestDispatcherOptions();
                op.setReplaceSuffix(this.thumbnailSupport.getServletErrorSuffix());
                op.setReplaceSelectors("transform");
                RequestDispatcher disp = request.getRequestDispatcher(this.thumbnailSupport.getServletErrorResourcePath(), op);
                disp.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void performTransformation(SlingHttpServletRequest request, SlingHttpServletResponse response, String transformationName, String renditionName, ResourceResolver serviceResolver) throws IOException, ExecutionException {
        Resource file = request.getResource();
        String originalContentType = response.getContentType();
        response.setContentType(OutputFileFormat.forRequest(request).getMimeType());
        Optional<Transformation> transformationOp = this.transformationCache.getTransformation(serviceResolver, transformationName);
        if (!transformationOp.isPresent()) {
            log.error("Unable to find transformation: {}", (Object)transformationName);
            response.setContentType(originalContentType);
            response.sendError(404, "Unable to find transformation: " + transformationName);
        } else {
            Transformation transformation = transformationOp.get();
            log.debug("Transforming file...");
            ByteArrayOutputStream baos = this.transform(request, response, transformation);
            if (this.renditionSupport.supportsRenditions(file)) {
                log.debug("Saving rendition...");
                this.renditionSupport.setRendition(file, renditionName, new ByteArrayInputStream(baos.toByteArray()));
            }
        }
    }

    private ByteArrayOutputStream transform(SlingHttpServletRequest request, SlingHttpServletResponse response, Transformation transformation) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformer.transform(request.getResource(), transformation, OutputFileFormat.forRequest(request), baos);
        IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)response.getOutputStream());
        return baos;
    }
}

