/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CM_COV_Object
extends Data {
    private static final long serialVersionUID = -5814207545197934085L;
    public double w = 0.0;
    public KahanObject mean = new KahanObject(0.0, 0.0);
    public KahanObject m2 = new KahanObject(0.0, 0.0);
    public KahanObject m3 = new KahanObject(0.0, 0.0);
    public KahanObject m4 = new KahanObject(0.0, 0.0);
    public KahanObject mean_v = new KahanObject(0.0, 0.0);
    public KahanObject c2 = new KahanObject(0.0, 0.0);

    public String toString() {
        return "weight: " + this.w + ", mean: " + this.mean + ", m2: " + this.m2 + ", m3: " + this.m3 + ", m4: " + this.m4 + ", mean2: " + this.mean_v + ", c2: " + this.c2;
    }

    public CM_COV_Object() {
        super(Expression.DataType.OBJECT, Expression.ValueType.UNKNOWN);
    }

    public void reset() {
        this.w = 0.0;
        this.mean = new KahanObject(0.0, 0.0);
        this.m2 = new KahanObject(0.0, 0.0);
        this.m3 = new KahanObject(0.0, 0.0);
        this.m4 = new KahanObject(0.0, 0.0);
        this.mean_v = new KahanObject(0.0, 0.0);
        this.c2 = new KahanObject(0.0, 0.0);
    }

    public int compareTo(CM_COV_Object that) {
        if (this.w != that.w) {
            return Double.compare(this.w, that.w);
        }
        if (this.mean != that.mean) {
            return KahanObject.compare(this.mean, that.mean);
        }
        if (this.m2 != that.m2) {
            return KahanObject.compare(this.m2, that.m2);
        }
        if (this.m3 != that.m3) {
            return KahanObject.compare(this.m3, that.m3);
        }
        if (this.m4 != that.m4) {
            return KahanObject.compare(this.m4, that.m4);
        }
        if (this.mean_v != that.mean_v) {
            return KahanObject.compare(this.mean_v, that.mean_v);
        }
        return KahanObject.compare(this.c2, that.c2);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CM_COV_Object)) {
            return false;
        }
        CM_COV_Object that = (CM_COV_Object)o;
        return this.w == that.w && this.mean.equals(that.mean) && this.m2.equals(that.m2) && this.m3.equals(that.m3) && this.m4.equals(that.m4) && this.mean_v.equals(that.mean_v) && this.c2.equals(that.c2);
    }

    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }

    public void set(CM_COV_Object that) {
        this.w = that.w;
        this.mean.set(that.mean);
        this.m2.set(that.m2);
        this.m3.set(that.m3);
        this.m4.set(that.m4);
        this.mean_v.set(that.mean_v);
        this.c2.set(that.c2);
    }

    public boolean isCMAllZeros() {
        return this.w == 0.0 && this.mean.isAllZero() && this.m2.isAllZero() && this.m3.isAllZero() && this.m4.isAllZero();
    }

    public boolean isCOVAllZeros() {
        return this.w == 0.0 && this.mean.isAllZero() && this.mean_v.isAllZero() && this.c2.isAllZero();
    }

    public double getRequiredResult(Operator op) {
        if (op instanceof CMOperator) {
            CMOperator.AggregateOperationTypes agg = ((CMOperator)op).aggOpType;
            return this.getRequiredResult(agg);
        }
        if (this.w == 1.0) {
            return 0.0;
        }
        return this.c2._sum / (this.w - 1.0);
    }

    public double getRequiredResult(CMOperator.AggregateOperationTypes agg) {
        switch (agg) {
            case COUNT: {
                return this.w;
            }
            case MEAN: {
                return this.mean._sum;
            }
            case CM2: {
                return this.m2._sum / this.w;
            }
            case CM3: {
                return this.m3._sum / this.w;
            }
            case CM4: {
                return this.m4._sum / this.w;
            }
            case VARIANCE: {
                return this.w == 1.0 ? 0.0 : this.m2._sum / (this.w - 1.0);
            }
        }
        throw new DMLRuntimeException("Invalid aggreagte in CM_CV_Object: " + (Object)((Object)agg));
    }

    public double getRequiredPartialResult(Operator op) {
        if (op instanceof CMOperator) {
            CMOperator.AggregateOperationTypes agg = ((CMOperator)op).aggOpType;
            switch (agg) {
                case COUNT: {
                    return 0.0;
                }
                case MEAN: {
                    return this.mean._sum;
                }
                case CM2: 
                case CM3: 
                case CM4: 
                case VARIANCE: {
                    throw new DMLRuntimeException("Aggregation operator '" + agg.toString() + "' does not apply to partial aggregation.");
                }
            }
            throw new DMLRuntimeException("Invalid aggreagte in CM_CV_Object: " + (Object)((Object)agg));
        }
        return this.c2._sum;
    }

    public double getWeight() {
        return this.w;
    }

    @Override
    public String getDebugName() {
        return "CM_COV_" + this.hashCode();
    }
}

