/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.sort.IndexSortComparable;
import org.apache.sysml.runtime.matrix.sort.IndexSortComparableDesc;

public class IndexSortMapper
extends MapReduceBase
implements Mapper<MatrixIndexes, MatrixBlock, IndexSortComparable, LongWritable> {
    private int _brlen = -1;
    private LongWritable _tmpLong = new LongWritable();
    private IndexSortComparable _tmpSortKey = null;

    public void map(MatrixIndexes key, MatrixBlock value, OutputCollector<IndexSortComparable, LongWritable> out, Reporter reporter) throws IOException {
        if (value.getNumColumns() > 1) {
            throw new IOException("IndexSort only supports column vectors, but found matrix block with clen=" + value.getNumColumns());
        }
        long row_offset = (key.getRowIndex() - 1L) * (long)this._brlen + 1L;
        for (int i = 0; i < value.getNumRows(); ++i) {
            double dval = value.quickGetValue(i, 0);
            long lix = row_offset + (long)i;
            this._tmpSortKey.set(dval, lix);
            this._tmpLong.set(lix);
            out.collect((Object)this._tmpSortKey, (Object)this._tmpLong);
        }
    }

    public void configure(JobConf job) {
        super.configure(job);
        this._brlen = MRJobConfiguration.getNumRowsPerBlock(job, (byte)0);
        boolean desc = job.getBoolean("sort.decreasing", false);
        this._tmpSortKey = !desc ? new IndexSortComparable() : new IndexSortComparableDesc();
    }
}

