/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.optim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Sgd
extends Script {
    public Sgd() {
        String string = "scripts/nn/optim/sgd.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix update(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/optim/sgd.dml') as mlcontextns;X = mlcontextns::update(X, dX, lr);";
        Script script = new Script(string);
        script.in("X", object).in("dX", object2).in("lr", object3).out("X");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        return matrix;
    }

    public String update__docs() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr)\n    return (matrix[double] X) {\n  /*\n   * Performs a vanilla SGD update.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   */\n";
        return string;
    }

    public String update__source() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr)\n    return (matrix[double] X) {\n  /*\n   * Performs a vanilla SGD update.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   */\n  X = X - lr*dX\n}\n";
        return string;
    }
}

