/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.ipc.LocalTransceiver;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Mail;
import org.apache.avro.test.Message;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcPluginOrdering {
    private static AtomicInteger orderCounter = new AtomicInteger();

    @Test
    public void testRpcPluginOrdering() throws Exception {
        OrderPlugin plugin = new OrderPlugin();
        SpecificResponder responder = new SpecificResponder(Mail.class, (Object)new TestMailImpl());
        SpecificRequestor requestor = new SpecificRequestor(Mail.class, (Transceiver)new LocalTransceiver((Responder)responder));
        responder.addRPCPlugin((RPCPlugin)plugin);
        requestor.addRPCPlugin((RPCPlugin)plugin);
        Mail client = (Mail)SpecificRequestor.getClient(Mail.class, (SpecificRequestor)requestor);
        Message message = this.createTestMessage();
        client.send(message);
    }

    private Message createTestMessage() {
        Message message = Message.newBuilder().setTo("me@test.com").setFrom("you@test.com").setBody("plugin testing").build();
        return message;
    }

    private static class TestMailImpl
    implements Mail {
        private TestMailImpl() {
        }

        @Override
        public String send(Message message) throws AvroRemoteException {
            return "Received";
        }

        @Override
        public void fireandforget(Message message) {
        }
    }

    public class OrderPlugin
    extends RPCPlugin {
        public void clientStartConnect(RPCContext context) {
            Assert.assertEquals((long)0L, (long)orderCounter.getAndIncrement());
        }

        public void clientSendRequest(RPCContext context) {
            Assert.assertEquals((long)1L, (long)orderCounter.getAndIncrement());
        }

        public void clientReceiveResponse(RPCContext context) {
            Assert.assertEquals((long)6L, (long)orderCounter.getAndIncrement());
        }

        public void clientFinishConnect(RPCContext context) {
            Assert.assertEquals((long)5L, (long)orderCounter.getAndIncrement());
        }

        public void serverConnecting(RPCContext context) {
            Assert.assertEquals((long)2L, (long)orderCounter.getAndIncrement());
        }

        public void serverReceiveRequest(RPCContext context) {
            Assert.assertEquals((long)3L, (long)orderCounter.getAndIncrement());
        }

        public void serverSendResponse(RPCContext context) {
            Assert.assertEquals((long)4L, (long)orderCounter.getAndIncrement());
        }
    }
}

