/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.pydml;

import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.parser.pydml.PydmlListener;
import org.apache.sysml.parser.pydml.PydmlParser;

public class PydmlPreprocessor
implements PydmlListener {
    protected final CustomErrorListener errorListener;
    protected Set<String> functions;

    public PydmlPreprocessor(CustomErrorListener errorListener) {
        this.errorListener = errorListener;
        this.functions = new HashSet<String>();
    }

    public Set<String> getFunctionDefs() {
        return this.functions;
    }

    @Override
    public void enterExternalFunctionDefExpression(PydmlParser.ExternalFunctionDefExpressionContext ctx) {
        this.validateFunctionName(ctx.name.getText(), ctx);
    }

    @Override
    public void exitExternalFunctionDefExpression(PydmlParser.ExternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterInternalFunctionDefExpression(PydmlParser.InternalFunctionDefExpressionContext ctx) {
        this.validateFunctionName(ctx.name.getText(), ctx);
    }

    @Override
    public void exitInternalFunctionDefExpression(PydmlParser.InternalFunctionDefExpressionContext ctx) {
    }

    protected void validateFunctionName(String name, ParserRuleContext ctx) {
        if (!this.functions.contains(name)) {
            this.functions.add(name);
        } else {
            this.notifyErrorListeners("Function Name Conflict: '" + name + "' already defined in " + this.errorListener.getCurrentFileName(), ctx.start);
        }
    }

    protected void notifyErrorListeners(String message, Token op) {
        this.errorListener.validationError(op.getLine(), op.getCharPositionInLine(), message);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void enterFunctionCallMultiAssignmentStatement(PydmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void exitFunctionCallMultiAssignmentStatement(PydmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void enterIgnoreNewLine(PydmlParser.IgnoreNewLineContext ctx) {
    }

    @Override
    public void exitIgnoreNewLine(PydmlParser.IgnoreNewLineContext ctx) {
    }

    @Override
    public void enterMatrixDataTypeCheck(PydmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void exitMatrixDataTypeCheck(PydmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void enterStrictParameterizedKeyValueString(PydmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void exitStrictParameterizedKeyValueString(PydmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void enterPathStatement(PydmlParser.PathStatementContext ctx) {
    }

    @Override
    public void exitPathStatement(PydmlParser.PathStatementContext ctx) {
    }

    @Override
    public void enterConstTrueExpression(PydmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void exitConstTrueExpression(PydmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void enterTypedArgNoAssign(PydmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void exitTypedArgNoAssign(PydmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void enterWhileStatement(PydmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void exitWhileStatement(PydmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void enterConstStringIdExpression(PydmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void exitConstStringIdExpression(PydmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void enterDataIdExpression(PydmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void exitDataIdExpression(PydmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void enterAtomicExpression(PydmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void exitAtomicExpression(PydmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void enterPowerExpression(PydmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void exitPowerExpression(PydmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallAssignmentStatement(PydmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void exitFunctionCallAssignmentStatement(PydmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void enterModIntDivExpression(PydmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void exitModIntDivExpression(PydmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void enterSimpleDataIdentifierExpression(PydmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void exitSimpleDataIdentifierExpression(PydmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void enterBuiltinFunctionExpression(PydmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void exitBuiltinFunctionExpression(PydmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void enterConstIntIdExpression(PydmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void exitConstIntIdExpression(PydmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void enterForStatement(PydmlParser.ForStatementContext ctx) {
    }

    @Override
    public void exitForStatement(PydmlParser.ForStatementContext ctx) {
    }

    @Override
    public void enterParameterizedExpression(PydmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitParameterizedExpression(PydmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterConstFalseExpression(PydmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void exitConstFalseExpression(PydmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void enterBooleanOrExpression(PydmlParser.BooleanOrExpressionContext ctx) {
    }

    @Override
    public void exitBooleanOrExpression(PydmlParser.BooleanOrExpressionContext ctx) {
    }

    @Override
    public void enterAssignmentStatement(PydmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void exitAssignmentStatement(PydmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void enterIterablePredicateColonExpression(PydmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void exitIterablePredicateColonExpression(PydmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void enterParForStatement(PydmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void exitParForStatement(PydmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void enterStrictParameterizedExpression(PydmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitStrictParameterizedExpression(PydmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterCommandlineParamExpression(PydmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void exitCommandlineParamExpression(PydmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void enterMultDivExpression(PydmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void exitMultDivExpression(PydmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void enterAddSubExpression(PydmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void exitAddSubExpression(PydmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void enterImportStatement(PydmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void exitImportStatement(PydmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void enterProgramroot(PydmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void exitProgramroot(PydmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void enterIterablePredicateSeqExpression(PydmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void exitIterablePredicateSeqExpression(PydmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void enterIfdefAssignmentStatement(PydmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void exitIfdefAssignmentStatement(PydmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void enterBooleanAndExpression(PydmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void exitBooleanAndExpression(PydmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void enterIndexedExpression(PydmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void exitIndexedExpression(PydmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void enterBooleanNotExpression(PydmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void exitBooleanNotExpression(PydmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void enterIfStatement(PydmlParser.IfStatementContext ctx) {
    }

    @Override
    public void exitIfStatement(PydmlParser.IfStatementContext ctx) {
    }

    @Override
    public void enterRelationalExpression(PydmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void exitRelationalExpression(PydmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void enterCommandlinePositionExpression(PydmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void exitCommandlinePositionExpression(PydmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void enterConstDoubleIdExpression(PydmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void exitConstDoubleIdExpression(PydmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void enterUnaryExpression(PydmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void exitUnaryExpression(PydmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void enterValueDataTypeCheck(PydmlParser.ValueDataTypeCheckContext ctx) {
    }

    @Override
    public void exitValueDataTypeCheck(PydmlParser.ValueDataTypeCheckContext ctx) {
    }

    @Override
    public void enterMl_type(PydmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void exitMl_type(PydmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void enterElifBranch(PydmlParser.ElifBranchContext ctx) {
    }

    @Override
    public void exitElifBranch(PydmlParser.ElifBranchContext ctx) {
    }
}

