/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers;

import io.netty.handler.codec.http.FullHttpResponse;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.Request;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.Response;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.IController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.CoordinatorModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.CoordinatorService;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.MapperService;

public class CoordinatorController
implements IController {
    private final CoordinatorService coordinatorService = new CoordinatorService();

    @Override
    public FullHttpResponse create(Request request) {
        CoordinatorModel model = MapperService.getModelFromBody(request, CoordinatorModel.class);
        model.generateMonitoringKey();
        model.id = this.coordinatorService.create(model);
        return Response.ok(model.toString());
    }

    @Override
    public FullHttpResponse update(Request request, Long objectId) {
        CoordinatorModel result = this.coordinatorService.get(objectId);
        if (result == null) {
            return Response.notFound("{\"message\": \"Entity not found\"}");
        }
        CoordinatorModel model = MapperService.getModelFromBody(request, CoordinatorModel.class);
        model.id = objectId;
        model.host = model.host == null ? result.host : model.host;
        model.processId = model.processId == null ? result.processId : model.processId;
        model.name = model.name == null ? result.name : model.name;
        model.generateMonitoringKey();
        this.coordinatorService.update(model);
        return Response.ok(model.toString());
    }

    @Override
    public FullHttpResponse delete(Request request, Long objectId) {
        this.coordinatorService.remove(objectId);
        return Response.ok("{\"message\": \"Success\"}");
    }

    @Override
    public FullHttpResponse get(Request request, Long objectId) {
        CoordinatorModel result = this.coordinatorService.get(objectId);
        if (result == null) {
            return Response.notFound("{\"message\": \"Entity not found\"}");
        }
        return Response.ok(result.toString());
    }

    @Override
    public FullHttpResponse getAll(Request request) {
        List<CoordinatorModel> coordinators = this.coordinatorService.getAll();
        return Response.ok(coordinators.toString());
    }
}

