/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.utils.Statistics;

public class LIBSVMReblockSPInstruction
extends UnarySPInstruction {
    private int _blen;
    private String _delim;
    private String _indexDelim;

    protected LIBSVMReblockSPInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, String opcode, String delim, String indexDelim, String instr) {
        super(SPInstruction.SPType.LIBSVMReblock, op, in, out, opcode, instr);
        this._blen = br;
        this._blen = bc;
        this._delim = delim;
        this._indexDelim = indexDelim;
    }

    public static LIBSVMReblockSPInstruction parseInstruction(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        if (!opcode.equals("libsvmrblk")) {
            throw new DMLRuntimeException("Incorrect opcode for LIBSVMReblockSPInstruction:" + opcode);
        }
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int blen = Integer.parseInt(parts[3]);
        String delim = parts[4];
        String indexDelim = parts[5];
        return new LIBSVMReblockSPInstruction(null, in, out, blen, blen, opcode, delim, indexDelim, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (iimd.getFileFormat() != Types.FileFormat.LIBSVM) {
            throw new DMLRuntimeException("The given format is not implemented for LIBSVMReblockSPInstruction:" + iimd.getFileFormat().toString());
        }
        DataCharacteristics mcIn = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        mcOut.set(mcIn.getRows(), mcIn.getCols(), this._blen);
        if (Recompiler.checkCPReblock(sec, this.input1.getName())) {
            if (this.input1.getDataType().isMatrix() || this.input1.getDataType().isFrame()) {
                Recompiler.executeInMemoryReblock(sec, this.input1.getName(), this.output.getName());
            }
            Statistics.decrementNoOfExecutedSPInst();
            return;
        }
        Object out = null;
        if (this.input1.getDataType() == Types.DataType.MATRIX) {
            out = this.processMatrixLIBSVMReblockInstruction(sec, mcOut);
        } else if (this.input1.getDataType() == Types.DataType.FRAME) {
            out = this.processFrameLIBSVMReblockInstruction(sec, mcOut, ((FrameObject)obj).getSchema());
        }
        sec.setRDDHandleForVariable(this.output.getName(), (JavaPairRDD<?, ?>)out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    protected JavaPairRDD<MatrixIndexes, MatrixBlock> processMatrixLIBSVMReblockInstruction(SparkExecutionContext sec, DataCharacteristics mcOut) {
        JavaPairRDD<?, ?> in = sec.getRDDHandleForMatrixObject(sec.getMatrixObject(this.input1), Types.FileFormat.LIBSVM);
        return RDDConverterUtils.libsvmToBinaryBlock(sec.getSparkContext(), in, mcOut, this._delim, this._indexDelim);
    }

    protected JavaPairRDD<Long, FrameBlock> processFrameLIBSVMReblockInstruction(SparkExecutionContext sec, DataCharacteristics mcOut, Types.ValueType[] schema) {
        JavaPairRDD<?, ?> in = sec.getRDDHandleForFrameObject(sec.getFrameObject(this.input1), Types.FileFormat.LIBSVM);
        return null;
    }
}

