/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.ISetSelectionTarget;

public final class ExtendedPlatformUI {
    public static final String SYSTEM_CONSOLE_NAME = "System Console";

    private ExtendedPlatformUI() {
    }

    public static Shell getActiveShell() {
        Display display = ExtendedPlatformUI.getDisplay();
        return display != null ? display.getActiveShell() : null;
    }

    public static Display getDisplay() {
        Display display;
        if (PlatformUI.isWorkbenchRunning() && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed()) {
            return display;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        final IWorkbenchPage[] page = new IWorkbenchPage[1];
        ExtendedPlatformUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    page[0] = window.getActivePage();
                }
            }
        });
        return page[0];
    }

    public static MessageConsoleStream out() {
        MessageConsole myConsole = ExtendedPlatformUI.findConsole("Extended Console");
        MessageConsoleStream out = myConsole.newMessageStream();
        IWorkbenchPage page = ExtendedPlatformUI.getActivePage();
        if (page == null) {
            throw new NullPointerException(NLS.bind((String)PlatformMessages.error_mustNotBeNull, (Object)"page"));
        }
        String id = "org.eclipse.ui.console.ConsoleView";
        try {
            IConsoleView view = (IConsoleView)page.showView(id);
            view.display((IConsole)myConsole);
        }
        catch (PartInitException partInitException) {}
        return out;
    }

    private static MessageConsole findConsole(String consoleName) {
        IConsole[] consoles;
        Assert.isNotNull((Object)consoleName);
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] iConsoleArray = consoles = consoleManager.getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole element = iConsoleArray[n2];
            if (consoleName.equals(element.getName())) {
                return (MessageConsole)element;
            }
            ++n2;
        }
        MessageConsole console = new MessageConsole(consoleName, null);
        consoleManager.addConsoles(new IConsole[]{console});
        return console;
    }

    public static boolean openConfirmDeleteDialog(String objectName) {
        String title = "Confirm Delete";
        String msg = "Are you sure you want to delete object \"{0}\"?";
        String message = NLS.bind((String)msg, (Object)objectName);
        return ExtendedPlatformUI.openQuestionDialog(title, message);
    }

    public static boolean openConfirmResetSelectionDialog() {
        String title = "Update Selection";
        String msg = "Selection changed and is now empty. Are you sure you want reset selection? (if no, previous selection will be restored";
        return ExtendedPlatformUI.openQuestionDialog(title, msg);
    }

    public static boolean openQuestionDialog(String title, String message) {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public static void showObjectsInActiveView(Collection<?> objects) {
        ExtendedPlatformUI.showObjectsInView(objects, null);
    }

    public static void showObjectsInView(Collection<?> objects, String viewId) {
        IWorkbenchPage page;
        if (objects != null && objects.size() > 0 && (page = ExtendedPlatformUI.getActivePage()) != null) {
            IWorkbenchPart activePart;
            if (viewId == null && (activePart = page.getActivePart()) instanceof IViewPart && activePart.getSite() != null) {
                viewId = activePart.getSite().getId();
            }
            if (viewId != null) {
                try {
                    IViewPart view = page.showView(viewId);
                    if (view instanceof ISetSelectionTarget) {
                        try {
                            StructuredSelection selection = new StructuredSelection(objects.toArray());
                            ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    public static void showSystemConsole() {
        MessageConsole systemConsole = null;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (SYSTEM_CONSOLE_NAME.equals(console.getName())) {
                systemConsole = (MessageConsole)console;
                break;
            }
            ++n2;
        }
        if (systemConsole == null) {
            systemConsole = new MessageConsole(SYSTEM_CONSOLE_NAME, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{systemConsole});
            MessageConsoleStream systemOutStream = systemConsole.newMessageStream();
            MessageConsoleStream systemErrStream = systemConsole.newMessageStream();
            systemErrStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 0, 0));
            System.setOut(new PrintStream((OutputStream)systemOutStream));
            System.setErr(new PrintStream((OutputStream)systemErrStream));
        }
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView(systemConsole);
    }
}

