/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.pde.util;

import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sphinx.jdt.util.JavaExtensions;

@SuppressWarnings("all")
public class PDEExtensions {
  private final static String PDE_EXECUTION_ENVIRONMENT_J2SE_15 = "J2SE-1.5";
  
  private final static String PDE_EXECUTION_ENVIRONMENT_JavaSE_16 = "JavaSE-1.6";
  
  private final static String PDE_EXECUTION_ENVIRONMENT_JavaSE_17 = "JavaSE-1.8";
  
  private final static String PDE_EXECUTION_ENVIRONMENT_JavaSE_18 = "JavaSE-1.8";
  
  /**
   * Gets the required execution environment.
   * 
   * @param compilerCompliance the Java compiler compliance
   * 
   * @return the required execution environment.
   */
  public static String getRequiredExecutionEnvironment(final String compilerCompliance) {
    String requiredExecutionEnvironment = null;
    boolean _equals = JavaCore.VERSION_1_5.equals(compilerCompliance);
    if (_equals) {
      requiredExecutionEnvironment = PDEExtensions.PDE_EXECUTION_ENVIRONMENT_J2SE_15;
    } else {
      boolean _equals_1 = JavaCore.VERSION_1_6.equals(compilerCompliance);
      if (_equals_1) {
        requiredExecutionEnvironment = PDEExtensions.PDE_EXECUTION_ENVIRONMENT_JavaSE_16;
      } else {
        boolean _equals_2 = JavaCore.VERSION_1_7.equals(compilerCompliance);
        if (_equals_2) {
          requiredExecutionEnvironment = PDEExtensions.PDE_EXECUTION_ENVIRONMENT_JavaSE_17;
        } else {
          boolean _equals_3 = JavaExtensions.VERSION_1_8.equals(compilerCompliance);
          if (_equals_3) {
            requiredExecutionEnvironment = PDEExtensions.PDE_EXECUTION_ENVIRONMENT_JavaSE_18;
          }
        }
      }
    }
    return requiredExecutionEnvironment;
  }
}
