/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.check.withcatalog;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.check.AbstractCheckValidator;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Component;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Connection;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.InstanceModel20Package;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.ComponentType;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Interface;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Port;

public class Hummingbird20ConnectionsCheckValidator
extends AbstractCheckValidator {
    public Hummingbird20ConnectionsCheckValidator() {
    }

    public Hummingbird20ConnectionsCheckValidator(CheckValidatorRegistry checkValidatorRegistry) {
        super(checkValidatorRegistry);
    }

    @Check(constraint="ConnectionTargetComponentNotValid", categories={"Category1"})
    void checkConnectionTargetComponent(Connection connection) {
        ComponentType componentType = null;
        Component targetComponent = connection.getTargetComponent();
        if (targetComponent != null) {
            componentType = targetComponent.getType();
        }
        Interface requiredInterface = null;
        Port sourcePort = connection.getSourcePort();
        if (sourcePort != null) {
            requiredInterface = sourcePort.getRequiredInterface();
        }
        if (componentType != null && requiredInterface != null && !componentType.getProvidedInterfaces().contains((Object)requiredInterface)) {
            this.issue((EObject)connection, (EStructuralFeature)InstanceModel20Package.eINSTANCE.getConnection_TargetComponent(), new Object[]{targetComponent.getName(), connection.getName(), requiredInterface.getName()});
        }
    }
}

