/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.workflows;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.check.operations.BasicCheckValidationOperation;
import org.eclipse.sphinx.emf.check.util.EclipseProgressMonitorAdapter;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractWorkspaceWorkflowComponent;

public abstract class AbstractCheckValidationWorkflowComponent
extends AbstractWorkspaceWorkflowComponent {
    private Set<String> categories;
    private boolean intrinsicModelIntegrityConstraintsEnabled;

    public Set<String> getCategories() {
        if (this.categories == null) {
            this.categories = new HashSet<String>();
        }
        return this.categories;
    }

    public boolean isIntrinsicModelIntegrityConstraintsEnabled() {
        return this.intrinsicModelIntegrityConstraintsEnabled;
    }

    public void setIntrinsicModelIntegrityConstraintsEnabled(boolean intrinsicModelIntegrityConstraintsEnabled) {
        this.intrinsicModelIntegrityConstraintsEnabled = intrinsicModelIntegrityConstraintsEnabled;
    }

    protected Map<Object, Object> createOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("CATEGORIES", this.getCategories());
        options.put("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS", this.intrinsicModelIntegrityConstraintsEnabled);
        return options;
    }

    protected BasicCheckValidationOperation createCheckValidationOperation(List<EObject> modelObjects, Map<Object, Object> options) {
        return new BasicCheckValidationOperation(modelObjects, options);
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        List models = (List)ctx.get("model");
        if (models == null || models.isEmpty()) {
            return;
        }
        try {
            BasicCheckValidationOperation operation = this.createCheckValidationOperation(models, this.createOptions());
            operation.run(new EclipseProgressMonitorAdapter(monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        catch (Exception ex) {
            issues.addError((WorkflowComponent)this, ex.getMessage(), (Object)models, (Throwable)ex, null);
        }
    }
}

