/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.internal.actions.providers;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.sphinx.emf.ui.actions.providers.BasicActionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;

public class UndoRedoOverrideActionProvider
extends BasicActionProvider {
    protected UndoActionHandler undoActionHandler;
    protected RedoActionHandler redoActionHandler;

    public void doInit() {
        IUndoContext undoContext = this.getUndoContext(this.workbenchPart);
        this.undoActionHandler = new UndoActionHandler(this.workbenchPart.getSite(), undoContext);
        this.undoActionHandler.setPruneHistory(true);
        this.redoActionHandler = new RedoActionHandler(this.workbenchPart.getSite(), undoContext);
        this.redoActionHandler.setPruneHistory(true);
        this.updateActionBars();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoActionHandler);
    }

    public void updateActionBars() {
        this.undoActionHandler.update();
        this.redoActionHandler.update();
    }

    private IUndoContext getUndoContext(IWorkbenchPart workbenchPart) {
        Object adapter;
        if (workbenchPart != null && (adapter = workbenchPart.getAdapter(IUndoContext.class)) != null) {
            return (IUndoContext)adapter;
        }
        return IOperationHistory.GLOBAL_UNDO_CONTEXT;
    }
}

