/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.BeanPropertySetterBuilder;
import org.apache.commons.digester3.binder.ByRuleBuilder;
import org.apache.commons.digester3.binder.ByRuleProviderBuilder;
import org.apache.commons.digester3.binder.CallMethodBuilder;
import org.apache.commons.digester3.binder.CallParamBuilder;
import org.apache.commons.digester3.binder.FactoryCreateBuilder;
import org.apache.commons.digester3.binder.FromBinderRuleSet;
import org.apache.commons.digester3.binder.NestedPropertiesBuilder;
import org.apache.commons.digester3.binder.NodeCreateRuleProvider;
import org.apache.commons.digester3.binder.ObjectCreateBuilder;
import org.apache.commons.digester3.binder.ObjectParamBuilder;
import org.apache.commons.digester3.binder.PathCallParamBuilder;
import org.apache.commons.digester3.binder.PluginCreateRuleBuilder;
import org.apache.commons.digester3.binder.PluginDeclarationRuleBuilder;
import org.apache.commons.digester3.binder.RuleProvider;
import org.apache.commons.digester3.binder.RulesBinder;
import org.apache.commons.digester3.binder.SetNextBuilder;
import org.apache.commons.digester3.binder.SetPropertiesBuilder;
import org.apache.commons.digester3.binder.SetPropertyBuilder;
import org.apache.commons.digester3.binder.SetRootBuilder;
import org.apache.commons.digester3.binder.SetTopBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedRuleBuilder {
    private final RulesBinder mainBinder;
    private final FromBinderRuleSet fromBinderRuleSet;
    private final ClassLoader classLoader;
    private final String keyPattern;
    private String namespaceURI;

    LinkedRuleBuilder(RulesBinder mainBinder, FromBinderRuleSet fromBinderRuleSet, ClassLoader classLoader, String keyPattern) {
        this.mainBinder = mainBinder;
        this.fromBinderRuleSet = fromBinderRuleSet;
        this.classLoader = classLoader;
        this.keyPattern = keyPattern;
    }

    public BeanPropertySetterBuilder setBeanProperty() {
        return this.addProvider(new BeanPropertySetterBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public CallMethodBuilder callMethod(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).callMethod( String ) } empty 'methodName' not allowed", this.keyPattern);
        }
        return this.addProvider(new CallMethodBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, methodName, this.classLoader));
    }

    public CallParamBuilder callParam() {
        return this.addProvider(new CallParamBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public PathCallParamBuilder callParamPath() {
        return this.addProvider(new PathCallParamBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public FactoryCreateBuilder factoryCreate() {
        return this.addProvider(new FactoryCreateBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, this.classLoader));
    }

    public ObjectCreateBuilder createObject() {
        return this.addProvider(new ObjectCreateBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, this.classLoader));
    }

    public <T> ObjectParamBuilder<T> objectParam(T paramObj) {
        return this.addProvider(new ObjectParamBuilder<T>(this.keyPattern, this.namespaceURI, this.mainBinder, this, paramObj));
    }

    public NestedPropertiesBuilder setNestedProperties() {
        NestedPropertiesBuilder nestedPropertiesBuilder = this.fromBinderRuleSet.getProvider(this.keyPattern, this.namespaceURI, NestedPropertiesBuilder.class);
        if (nestedPropertiesBuilder != null) {
            return nestedPropertiesBuilder;
        }
        return this.addProvider(new NestedPropertiesBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public SetNextBuilder setNext(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).setNext( String ) } empty 'methodName' not allowed", this.keyPattern);
        }
        return this.addProvider(new SetNextBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, methodName, this.classLoader));
    }

    public SetPropertiesBuilder setProperties() {
        SetPropertiesBuilder setPropertiesBuilder = this.fromBinderRuleSet.getProvider(this.keyPattern, this.namespaceURI, SetPropertiesBuilder.class);
        if (setPropertiesBuilder != null) {
            return setPropertiesBuilder;
        }
        return this.addProvider(new SetPropertiesBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public SetPropertyBuilder setProperty(String attributePropertyName) {
        if (attributePropertyName == null || attributePropertyName.length() == 0) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).setProperty( String ) } empty 'attributePropertyName' not allowed", this.keyPattern);
        }
        return this.addProvider(new SetPropertyBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, attributePropertyName));
    }

    public SetRootBuilder setRoot(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).setRoot( String ) } empty 'methodName' not allowed", this.keyPattern);
        }
        return this.addProvider(new SetRootBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, methodName, this.classLoader));
    }

    public SetTopBuilder setTop(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).setTop( String ) } empty 'methodName' not allowed", this.keyPattern);
        }
        return this.addProvider(new SetTopBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this, methodName, this.classLoader));
    }

    public PluginDeclarationRuleBuilder declarePlugin() {
        return this.addProvider(new PluginDeclarationRuleBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public PluginCreateRuleBuilder createPlugin() {
        return this.addProvider(new PluginCreateRuleBuilder(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public NodeCreateRuleProvider createNode() {
        return this.addProvider(new NodeCreateRuleProvider(this.keyPattern, this.namespaceURI, this.mainBinder, this));
    }

    public <R extends Rule> ByRuleBuilder<R> addRule(R rule) {
        if (rule == null) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).addRule( R ) } NULL rule not valid", this.keyPattern);
        }
        return this.addProvider(new ByRuleBuilder<R>(this.keyPattern, this.namespaceURI, this.mainBinder, this, rule));
    }

    public <R extends Rule> ByRuleProviderBuilder<R> addRuleCreatedBy(RuleProvider<R> provider) {
        if (provider == null) {
            this.mainBinder.addError("{ forPattern( \"%s\" ).addRuleCreatedBy() } null rule provider not valid", this.keyPattern);
        }
        return this.addProvider(new ByRuleProviderBuilder<R>(this.keyPattern, this.namespaceURI, this.mainBinder, this, provider));
    }

    public LinkedRuleBuilder withNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI == null || namespaceURI.length() > 0 ? namespaceURI : null;
        return this;
    }

    private <R extends Rule, RB extends AbstractBackToLinkedRuleBuilder<R>> RB addProvider(RB provider) {
        this.fromBinderRuleSet.registerProvider(provider);
        return provider;
    }
}

