/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.geometry;

import java.io.Serializable;

public final class Interval
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final Interval INFINITE = new Interval(0, Integer.MAX_VALUE);
    public int begin;
    public int length;

    public Interval() {
    }

    public Interval(int begin, int length) {
        this.begin = begin;
        this.length = length;
    }

    public Interval(Interval interval) {
        this.begin = interval.begin;
        this.length = interval.length;
    }

    public boolean equals(Object o) {
        if (o instanceof Interval) {
            Interval interval = (Interval)o;
            return interval.begin == this.begin && interval.length == this.length;
        }
        return false;
    }

    public int hashCode() {
        return this.begin ^ this.length << 10;
    }

    public String toString() {
        return "Interval(" + this.begin + ", " + this.length + ")";
    }

    public int begin() {
        return this.begin;
    }

    public int length() {
        return this.length;
    }

    public int end() {
        return this.begin + this.length;
    }

    public int center() {
        return this.begin + this.length / 2;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean contains(int value) {
        return this.begin <= value && value < this.end();
    }

    public boolean intersects(Interval interval) {
        return interval.begin < this.end() && this.begin < interval.end();
    }

    public boolean isLeadingOf(Interval interval) {
        return this.begin < interval.begin;
    }

    public boolean isTrailingOf(Interval interval) {
        return this.end() > interval.end();
    }

    public int distance(int point) {
        if (point < this.begin) {
            return this.begin - point;
        }
        if (point > this.end()) {
            return point - this.end();
        }
        return 0;
    }

    public Interval getIntersection(Interval interval) {
        int x1 = Math.max(this.begin, interval.begin);
        int x2 = Math.min(this.end(), interval.end());
        if (x2 - x1 < 0) {
            return new Interval();
        }
        return new Interval(x1, x2 - x1);
    }

    public Interval getCopy() {
        return new Interval(this.begin, this.length);
    }

    public void setBegin(int newBegin) {
        this.length += this.begin - newBegin;
        this.begin = newBegin;
    }

    public void growLeading(int delta) {
        this.begin += delta;
        this.length -= delta;
    }

    public void growTrailing(int delta) {
        this.length += delta;
    }

    @Deprecated
    public void setBeginKeepEnd(int newBegin) {
        this.setBegin(newBegin);
    }

    @Deprecated
    public void moveBeginKeepEnd(int delta) {
        this.growLeading(delta);
    }

    @Deprecated
    public void moveEndKeepBegin(int delta) {
        this.growTrailing(delta);
    }

    public static Interval[] getCopy(Interval[] intervals) {
        Interval[] intervalsCopy = new Interval[intervals.length];
        int i = 0;
        while (i < intervals.length) {
            intervalsCopy[i] = intervals[i].getCopy();
            ++i;
        }
        return intervalsCopy;
    }

    public static int getRightmostIntervalIndex(Interval[] intervals, int value) {
        int index = -1;
        int i = 0;
        while (i < intervals.length) {
            Interval interval = intervals[i];
            if (interval.begin + interval.length / 2 < value) {
                index = i;
            }
            ++i;
        }
        return index;
    }
}

