/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public abstract class FieldVariableSupport
extends AbstractSimpleVariableSupport {
    public static final String[] V_MODIFIER_CODE = new String[]{"private ", "", "protected ", "public "};
    public static final int V_FIELD_MODIFIER_PRIVATE = 0;
    public static final int V_FIELD_MODIFIER_PACKAGE = 1;
    public static final int V_FIELD_MODIFIER_PROTECTED = 2;
    public static final int V_FIELD_MODIFIER_PUBLIC = 3;

    public FieldVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public FieldVariableSupport(JavaInfo javaInfo, Expression variable) {
        super(javaInfo, variable);
    }

    @Override
    public boolean isValidStatementForChild(Statement statement) {
        if (statement instanceof Block) {
            return AstNodeUtils.getEnclosingBlock((ASTNode)this.m_variable) != statement;
        }
        return true;
    }

    @Override
    public String getComponentName() {
        return this.m_utils.stripPrefixSuffix(this.getName(), "org.eclipse.jdt.core.codeComplete.fieldPrefixes", "org.eclipse.jdt.core.codeComplete.fieldSuffixes");
    }

    @Override
    public String getReferenceExpression(NodeTarget target) throws Exception {
        this.assertJavaInfoCreatedAt(target);
        FieldDeclaration fieldDeclaration = AstNodeUtils.getEnclosingNode((ASTNode)this.m_declaration, FieldDeclaration.class);
        boolean isStatic = AstNodeUtils.isStatic((BodyDeclaration)fieldDeclaration);
        String fieldName = this.getName();
        return !isStatic && this.prefixThis() ? "this." + fieldName : fieldName;
    }

    @Override
    public final boolean canConvertLocalToField() {
        return false;
    }

    @Override
    public final void convertLocalToField() throws Exception {
        throw new IllegalStateException();
    }

    protected final void delete_removeDeclarationField() throws Exception {
        this.m_javaInfo.getEditor().removeVariableDeclaration(this.m_declaration);
    }

    @Override
    String decorateTextName(String newName) {
        return this.m_utils.addPrefixSuffix(newName, "org.eclipse.jdt.core.codeComplete.fieldPrefixes", "org.eclipse.jdt.core.codeComplete.fieldSuffixes");
    }

    protected abstract boolean prefixThis();
}

