/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.properties;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfoVisitor;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.parser.DatabindingParser;

public final class BeanPropertyInfo
extends PropertyInfo {
    private final PropertyInfo m_baseProperty;
    private String m_path;
    private String[] m_properties;

    public BeanPropertyInfo(IGenericType sourceObjectType, IGenericType valueType, PropertyInfo baseProperty, String path) {
        super(sourceObjectType, valueType);
        this.m_baseProperty = baseProperty;
        this.setPath(path);
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        Assert.isNotNull((Object)path);
        this.m_path = path;
        this.m_properties = StringUtils.split((String)this.m_path, (char)'.');
    }

    @Override
    public ObserveInfo getObserveProperty(ObserveInfo observeObject) throws Exception {
        if (this.m_baseProperty != null) {
            Assert.instanceOf(BeanPropertyInfo.class, (Object)((Object)this.m_baseProperty));
            observeObject = this.m_baseProperty.getObserveProperty(observeObject);
            if (observeObject == null) {
                return null;
            }
        }
        String[] stringArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            boolean found = false;
            for (ObserveInfo observeProperty : CoreUtils.cast((List)observeObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable))) {
                if (!observeProperty.isRepresentedBy(property)) continue;
                observeObject = observeProperty;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            ++n2;
        }
        return observeObject;
    }

    @Override
    public boolean canShared(PropertyInfo property) {
        if (property instanceof BeanPropertyInfo) {
            BeanPropertyInfo beanProperty;
            if (DatabindingParser.useGenerics) {
                if (!this.m_sourceObjectType.getFullTypeName().equals(property.getSourceObjectType().getFullTypeName())) {
                    return false;
                }
                if (!this.m_valueType.getFullTypeName().equals(property.getValueType().getFullTypeName())) {
                    return false;
                }
            }
            if (!this.m_path.equals((beanProperty = (BeanPropertyInfo)property).getPath())) {
                return false;
            }
            if (this.m_baseProperty != null && beanProperty.m_baseProperty == null || this.m_baseProperty == null && beanProperty.m_baseProperty != null) {
                return false;
            }
            if (this.m_baseProperty != null && beanProperty.m_baseProperty != null) {
                return this.m_baseProperty.canShared(beanProperty.m_baseProperty);
            }
            return true;
        }
        return false;
    }

    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        if (this.getVariableIdentifier() == null) {
            this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{this.m_sourceObjectType.getSimpleTypeName(), "BeanProperty"}));
        }
        String base = "";
        if (this.m_baseProperty != null) {
            generationSupport.addSourceCode((AstObjectInfo)this.m_baseProperty, lines);
            base = String.valueOf(this.m_baseProperty.getVariableIdentifier()) + ", ";
        }
        if (generationSupport.useGenerics()) {
            lines.add("org.jdesktop.beansbinding.BeanProperty" + GenericUtils.getTypesSource(this.m_sourceObjectType, this.m_valueType) + " " + this.getVariableIdentifier() + " = org.jdesktop.beansbinding.BeanProperty.create(" + base + "\"" + this.m_path + "\");");
        } else {
            lines.add("org.jdesktop.beansbinding.Property " + this.getVariableIdentifier() + " = org.jdesktop.beansbinding.BeanProperty.create(" + base + "\"" + this.m_path + "\");");
        }
    }

    public void accept(AstObjectInfoVisitor visitor) throws Exception {
        super.accept(visitor);
        if (this.m_baseProperty != null) {
            this.m_baseProperty.accept(visitor);
        }
    }

    @Override
    public String getPresentationText(IObserveInfo observeObject, IObserveInfo observeProperty, boolean full) throws Exception {
        if (full && observeObject == null && observeProperty == null) {
            String presentationText = "";
            if (this.m_baseProperty != null) {
                presentationText = String.valueOf(this.m_baseProperty.getPresentationText(null, null, true)) + ".";
            }
            return String.valueOf(presentationText) + this.m_path;
        }
        if (full && this.m_path.length() > 0) {
            String basePresentationText = "";
            if (this.m_baseProperty != null) {
                basePresentationText = String.valueOf(this.m_baseProperty.getPresentationText(null, null, true)) + ".";
            }
            return String.valueOf(observeObject.getPresentation().getTextForBinding()) + "." + basePresentationText + this.m_path;
        }
        return super.getPresentationText(observeObject, observeProperty, full);
    }
}

