# Copyright (c) 2014 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Summary: GNU ccScript - a C++ framework for threaded scripting engine.
Name: ccscript
Version: 5.0.2
Release: 0
License: LGPL v3+
Group: Development/Libraries
URL: http://www.gnu.org/software/commoncpp/commoncpp.html
Source0: ftp://ftp.gnu.org/gnu/ccscript/ccscript-%{version}.tar.gz
BuildRequires: ucommon-devel >= 6.0.0
BuildRequires: pkgconfig(ucommon)
BuildRequires: gcc-c++
BuildRequires: cmake

%package devel
Group: Development/Libraries
Summary: Headers and static link library for GNU ccScript
Requires: %{name}%{?_isa} = %{version}-%{release} 
Requires: ucommon-devel%{?_isa} >= 6.0.0

%description
GNU ccScript is a C++ class framework for creating a virtual machine
execution system for use with and as a scripting/assembler language for
state-transition driven realtime systems. 

%description devel
This package provides the header files, link libraries, and 
documentation for building applications that use GNU ccScript. 

%prep
%setup -q

%build
%cmake \
      -DCMAKE_INSTALL_PREFIX=%{_prefix} \
      -DSYSCONFDIR=%{_sysconfdir} \
      -DINSTALL_MANDIR=%{_mandir} \
      -DINSTALL_INCLUDEDIR=%{_includedir} \
      -DINSTALL_DATADIR=%{_datadir} \
      -DINSTALL_BINDIR=%{_bindir} \
      -DINSTALL_LIBDIR=%{_libdir} \
      .

%{__make} %{?_smp_mflags}

%install
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install

%files
%doc AUTHORS COPYING ChangeLog NEWS README
%{_libdir}/*.so.*

%files devel
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc
%{_includedir}/ccscript.h

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig  

%changelog

