/* LocaleInformation_fo.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_fo extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "DKK";

  private static final String currenciesDisplayNameValues = "DKK";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "DKK";

  private static final String currenciesSymbolValues = "kr";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "mai",
    "jun",
    "jul",
    "aug",
    "sep",
    "okt",
    "nov",
    "des",
    null,
  };

  private static final String[] months = {
    "januar",
    "februar",
    "mars",
    "apr\u00edl",
    "mai",
    "juni",
    "juli",
    "august",
    "september",
    "oktober",
    "november",
    "desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "sun",
    "m\u00e1n",
    "t\u00fds",
    "mik",
    "h\u00f3s",
    "fr\u00ed",
    "ley",
  };

  private static final String[] weekdays = {
    null,
    "sunnudagur",
    "m\u00e1nadagur",
    "t\u00fdsdagur",
    "mikudagur",
    "h\u00f3sdagur",
    "fr\u00edggjadagur",
    "leygardagur",
  };

  private static final String territoriesKeys = "AU|TD|GY|AT|GW|AQ|MZ|MY|MX|MW|GR|ZA|MV|GQ|SZ|MU|MR|AG|AF|ST|AE|SR|MK|MH|MG|MC|SG|MA|SE|SC|SB|SA|YE|FR|LV|LU|LT|FO|LS|RW|FM|RU|FI|RO|LI|LC|LB|KZ|ET|ES|KW|KR|KP|KN|KM|EG|EE|WS|KH|EC|KG|KE|QA|PY|DO|DM|DK|JM|DE|PL|PH|PG|PE|CZ|CY|CV|VE|CU|VC|CR|VA|IT|CO|IS|CN|CM|IQ|CL|UZ|UY|CI|CH|IL|CG|CF|US|CA|IE|BZ|BY|BW|BT|BR|UA|NZ|HU|HR|TZ|TW|TT|NO|BE|BD|ZW|TR|NL|BA|TN|NI|TJ|AZ|ZM";

  private static final String territoriesValues = "Avstralia|Kjad|Gujana|Eysturr\u00edki|Guinea Bissau|Antarktis|Mosambik|Maleisia|Meksiko|Malavi|Grikkaland|Su\u00f0urafrika|Maldivuoyggjarnar|Ekvator Guinea|Svasiland|M\u00f3ritius|M\u00f3ritania|Antigua og Barbuda|Afganistan|Sao Tome og Prinsipi|Sameindu Emirr\u00edkini|Surinam|Maked\u00f3nia|Marshalloyggjarnar|Madagaskar|Monako|Singapor|Marokko|Sv\u00f8r\u00edki|Seyskelloyggjarnar|S\u00e1lomonoyggjarnar|Saudi-Ar\u00e1bia|Jemen|Frakland|Lettland|Luksemborg|Litava|F\u00f8royar|Lesoto|Ruanda|Mikronesia|Russland|Finnland|Rumenia|Liktenstein|Saint Lusia|Libanon|Kasakstan|Etiopia|Spania|Kuvait|Su\u00f0ur-Korea|Nor\u00f0ur-Korea|Saint Kitts og Nevis|Komorooyggjarnar|Egyptaland|Estland|S\u00e1moa|Kambodja|Ekvador|Kirgisia|Kenja|Katar|Paraguei|Domingo l\u00fd\u00f0veldi\u00f0|Dominika|Danm\u00f8rk|Jameika|T\u00fdskland|P\u00f3lland|Filipsoyggjar|Papua N\u00fdguinea|Per\u00fa|Kekkia|K\u00fdpros|Gr\u00f8nh\u00f8vdaoyggjarnar|Venesuela|Kuba|Saint Vinsent og Grenadinoyggjar|Kosta Rika|Vatikan|Italia|Kolombia|\u00cdsland|Kina|Kamerun|Irak|Kili|Usbekistan|Uruguei|F\u00edlabeinsstrondin|Sveis|\u00cdsrael|Kongo|Mi\u00f0afrikal\u00fd\u00f0veldi\u00f0|Sambandsr\u00edki Amerika|Kanada|\u00cdrland|Belis|Hv\u00edtarussland|Botsvana|Butan|Brasilia|Ukreina|N\u00fd S\u00e6land|Ungarn|Kroatia|Tansania|Teivan|Trinidad og Tobago|Noreg|Belgia|Bangladesj|Simbabvi|Turkaland|Ni\u00f0urlond|Bosnia-Hersegovina|Tunesia|Nikaragua|Tadsjikistan|Aserbajdsjan|Sambia";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "fo";

  private static final String languagesValues = "f\u00f8royskt";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "shortDateFormat", "dd-MM-yy" },
    { "mediumDateFormat", "dd-MM-yyyy" },
    { "longDateFormat", "d. MMM yyyy" },
    { "fullDateFormat", "EEEE dd MMMM yyyy" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
