/* LocaleInformation_id.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_id extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "IDR";

  private static final String currenciesDisplayNameValues = "IDR";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "IDR";

  private static final String currenciesSymbolValues = "Rp";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "Mei",
    "Jun",
    "Jul",
    "Agu",
    "Sep",
    "Okt",
    "Nov",
    "Des",
    null,
  };

  private static final String[] months = {
    "Januari",
    "Februari",
    "Maret",
    "April",
    "Mei",
    "Juni",
    "Juli",
    "Agustus",
    "September",
    "Oktober",
    "November",
    "Desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Min",
    "Sen",
    "Sel",
    "Rab",
    "Kam",
    "Jum",
    "Sab",
  };

  private static final String[] weekdays = {
    null,
    "Minggu",
    "Senin",
    "Selasa",
    "Rabu",
    "Kamis",
    "Jumat",
    "Sabtu",
  };

  private static final String territoriesKeys = "TK|TJ|TH|TG|GY|TD|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Tokelau|Tajikistan|Thailand|Togo|Guyana|Chad|Guinea-Bissau|Guam|Guatemala|Georgia Selatan dan Kepulauan Sandwich Selatan|Yunani|Guinea Khatulistiwa|Guadeloupe|Swaziland|Syria|Guinea|Gambia|Greenland|El Salvador|Sao Tome dan Principe|Gibraltar|Ghana|Suriname|Guyana Perancis|Serbia|Georgia|Somalia|Grenada|Senegal|San Marino|Inggris Raya|Sierra Leone|Gabon|Slovakia|Svalbard dan Jan Mayen|Slovenia|Saint Helena|Singapura|Sweden|Sudan|Seychelles|Kepulauan Solomon|Arab Saudi|Perancis|Kepulauan Faroe|Mikronesia|Rwanda|Kepulauan Falkland|Rusia|Fiji|Finlandia|Romania|R\u00e9union|Ethiopia|Spanyol|Eritrea|Sahara Barat|Mesir|Estonia|Ekuador|Algeria|Qatar|Republik Dominika|Paraguay|Dominika|Palau|Denmark|Jibouti|Portugis|Otoritas Palestina|Puerto Riko|Jerman|Pitcairn|Saint Pierre dan Miquelon|Polandia|Pakistan|Filipina|Papua Nugini|Polynesia Perancis|Republik Ceko|Peru|Siprus|Pulau Christmas|Tanjung Verde|Panama|Kuba|Kosta Rika|Kolombia|Cina|Kamerun|Chili|Kepulauan Cook|Pantai Gading|Swiss|Kongo|Republik Afrika Tengah|Republik Demokratik Kongo|Kepulauan Cocos|Oman|Kanada|Belize|Belarusia|Botswana|Kepulauan Bouvet|Bhutan|Bahamas|Brazil|Selandia Baru|Bolivia|Brunei|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgaria|Burkina Faso|Nepal|Belgia|Norwegia|Bangladesh|Barbados|Zimbabwe|Netherlands|Bosnia dan Herzegovina|Nicaragua|Nigeria|Kepulauan Norfolk|Azerbaijan|Niger|Kaledonia Baru|Aruba|Zambia|Namibia|Australia|Austria|Samoa Amerika|Argentina|Antarktika|Mozambique|Angola|Malaysia|Antilles Belanda|Mexico|Armenia|Malawi|Albania|Maldives|Afrika Selatan|Mauritius|Malta|Anguilla|Montserrat|Mauritania|Antigua dan Barbuda|Martinique|Afghanistan|Kepualuan Mariana Utara|Uni Emirat Arab|Makao S.A.R. Cina|Andora|Mongolia|Myanmar|Mali|Macedonia|Yugoslavia|Mayotte|Kepulauan Marshall|Madagaskar|Moldova|Monaco|Maroko|Yaman|Libya|Latvia|Luxembourg|Lithuania|Lesotho|Liberia|Sri Lanka|Liechtenstein|Santa Lusia|Lebanon|Laos|Kazakhstan|Kepulauan Kayman|Kuwait|Korea Selatan|Korea Utara|Saint Kitts dan Nevis|Komoros|Kiribati|Samoa|Kamboja|Kyrgyzstan|Kenya|Wallis dan Futuna|Jepang|Yordania|Jamaika|Vanuatu|Vietnam|Kepulauan U.S. Virgin|Kepulauan British Virgin|Venezuela|Saint Vincent dan Grenadines|Vatikan|Itali|Islandia|Iran|Iraq|Uzbekistan|Uruguay|India|Israel|Amerika Serikat|Irlandia|Indonesia|Uganda|Ukraina|Hungaria|Haiti|Kroasia|Tanzania|Honduras|Pulau Heard dan Kepulauan McDonald|Taiwan|Tuvalu|Hong Kong S.A.R., Cina|Trinidad dan Tobago|Turkey|Tonga|Tunisia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ast|lb|la|xh|ky|kw|kv|ku|ks|kr|ko|kn|km|kl|kk|kj|ki|kg|grc|wo|art|ka|gem|arn|afa|jv|wa|arc|cel|vo|ja|vi|ve|it|is|uz|io|ik|ii|ur|ig|kos|ie|id|ia|uk|kok|ug|hz|hy|got|hu|phi|hr|ho|ty|apa|tw|fur|goh|tt|hi|ts|tr|cop|he|tn|tl|ha|tk|ti|ace|th|tg|te|gv|ta|syr|gu|map|bug|mak|gn|sw|gl|sv|su|enm|ss|mad|sr|sq|so|gd|sn|sm|sl|ga|sk|si|sh|sg|se|fy|sd|sc|sa|cau|ang|car|fr|fo|rw|gmh|ru|fj|cai|fi|ff|ro|rn|rm|fa|peo|lez|eu|et|es|eo|en|el|qu|jrb|fro|frm|ee|mkh|dz|dv|alg|pt|ps|de|pl|da|pi|sux|jpr|cy|akk|cv|pa|cs|cr|co|mis|os|ch|or|ce|om|ca|oj|bs|br|gil|bo|ny|bn|bm|nv|bi|bh|bg|be|no|nn|nl|ba|zu|ng|az|ne|ay|nb|av|na|aus|as|ar|zh|my|am|ak|za|paa|mt|ms|mr|af|ae|mo|haw|mn|ab|ml|aa|mk|chk|mi|mh|mg|mga|yo|egy|yi|bat|lv|ath|lu|lt|ban|lo|ln|bai|li|lg";

  private static final String languagesValues = "Astur|Luxembourg|Latin|Xhosa|Kirghiz|Cornish|Komi|Kurdi|Kashmir|Kanuri|Korea|Kannada|Khmer|Kalaallisut|Kazakh|Kuanyama|Kikuyu|Kongo|Yunani Kuno (sd 1453)|Wolof|Buatan (Lainnya)|Georgian|Jermanik (Lainnya)|Araucan|Afro-Asiatik (Lainnya)|Jawa|Walloon|Aram|Celtic (Lainnya)|Volap\u00fck|Japanese|Vietnamese|Venda|Italian|Icelandic|Uzbek|Ido|Inupiaq|Sichuan Yi|Urdu|Igbo|Kosrae|Interlingue|Bahasa Indonesia|Interlingua|Ukrainian|Konkani|Uighur|Herero|Armenia|Gothik|Hungaria|Filipina (Lainnya)|Kroasia|Hiri Motu|Tahitian|Bahasa-bahasa Apache|Twi|Friuli|Jerman Kuno (kl.750-1050)|Tatar|Hindi|Tsonga|Turkish|Koptik|Ibrani|Tswana|Tagalog|Hausa|Turkmen|Tigrinya|Aceh|Thai|Tajik|Telugu|Manx|Tamil|Syria|Gujarati|Austronesia|Bugis|Makassar|Guarani|Swahili|Gallegan|Swedia|Sundan|Inggris, Abad Pertengahan (1100-1500)|Swati|Madura|Serbian|Albanian|Somali|Gaelik Skotlandia|Shona|Samoan|Slovenian|Irlandia|Slovak|Sinhalese|Serbo-Croatian|Sango|Northern Sami|Frisi|Sindhi|Sardinian|Sanskrit|Kaukasia (Lainnya)|Inggris Kuno (kl.450-1100)|Karib|Perancis|Faro|Kinyarwanda|Jerman, Abad Pertengahan (kl.1050-1500)|Russian|Fiji|India Amerika Tengah (Lainnnya)|Finlandia|Fulah|Romanian|Rundi|Rhaeto-Romance|Persia|Persia Kuno (kl.600-400 SM.)|Lezghia|Basque|Estonian|Spanyol|Esperanto|Inggris|Yunani|Quechua|Judeo-Arab|Perancis Kuno (842-kl.1400)|Perancis, Abad Pertengahan (kl.1400-1600)|Ewe|Mon-Khmer (Lainnya)|Dzongkha|Divehi|Bahasa Algonquia|Portugis|Pashto (Pushto)|Jerman|Polish|Denmark|Pali|Sumeria|Judeo-Persia|Welsh|Akkadien|Chuvash|Punjabi|Ceko|Cree|Korsika|Bahasa Lain-lain|Ossetic|Chamorro|Oriya|Chechen|Oromo|Catalan|Ojibwa|Bosnia|Breton|Gilbert|Tibet|Nyanja; Chichewa; Chewa|Bengal|Bambara|Navajo|Bislama|Bihari|Bulgaria|Belarusia|Norwegian|Norwegian Nynorsk|Belanda|Bashkir|Zulu|Ndonga|Azerbaijan|Nepal|Aymara|Norwegian Bokm\u00e5l|Avarik|Nauru|Bahasa-bahasa Australia|Assam|Arab|Cina|Burma|Amharik|Akan|Zhuang|Papuan (Lainnya)|Maltese|Malay|Marathi|Afrikaans|Avestan|Moldavian|Hawaii|Mongolian|Abkhaz|Malayalam|Afar|Macedonian|Chuuke|Maori|Marshall|Malagasi|Irlandia Abad Pertengahan (900-1200)|Yoruba|Mesir Kuno|Yiddish|Baltik (Lainnya)|Latvian|Bahasa-bahasa Athapaska|Luba-Katanga|Lithuania|Balin|Lao|Lingala|Bahasa-bahasa Bamileke|Limburg|Ganda";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currencyFormat", "\u00a4#,##0.00;-\u00a4#,##0.00" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
