/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class BasicDesktopIconUI
extends DesktopIconUI {
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    JComponent iconPane;
    MouseInputListener mouseInputListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.frame = this.desktopIcon.getInternalFrame();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.desktopIcon = null;
        this.frame = null;
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.iconPane = new BasicInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.desktopIcon.addMouseMotionListener(this.mouseInputListener);
        this.desktopIcon.addMouseListener(this.mouseInputListener);
    }

    protected void uninstallListeners() {
        this.desktopIcon.removeMouseMotionListener(this.mouseInputListener);
        this.desktopIcon.removeMouseListener(this.mouseInputListener);
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.desktopIcon, "DesktopIcon.border");
    }

    protected void uninstallDefaults() {
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        int n = 157;
        int n2 = 18;
        if (border != null) {
            n2 += border.getBorderInsets((Component)jInternalFrame).bottom + border.getBorderInsets((Component)jInternalFrame).top;
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.iconPane.getMinimumSize();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.iconPane.getMaximumSize();
    }

    public Insets getInsets(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            return border.getBorderInsets(jInternalFrame);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public class MouseInputHandler
    extends MouseInputAdapter {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        public void mouseReleased(MouseEvent mouseEvent) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            JDesktopPane jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.endDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = BasicDesktopIconUI.this.desktopIcon.getBounds();
            JDesktopPane jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.beginDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
            try {
                BasicDesktopIconUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (BasicDesktopIconUI.this.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)BasicDesktopIconUI.this.desktopIcon.getParent()).moveToFront(BasicDesktopIconUI.this.desktopIcon);
            }
            if (mouseEvent.getClickCount() > 1 && BasicDesktopIconUI.this.frame.isIconifiable() && BasicDesktopIconUI.this.frame.isIcon()) {
                BasicDesktopIconUI.this.deiconize();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JDesktopPane jDesktopPane;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            Insets insets = BasicDesktopIconUI.this.desktopIcon.getInsets();
            int n = ((JComponent)BasicDesktopIconUI.this.desktopIcon.getParent()).getWidth();
            int n2 = ((JComponent)BasicDesktopIconUI.this.desktopIcon.getParent()).getHeight();
            if (this.startingBounds == null) {
                return;
            }
            int n3 = this.startingBounds.x - (this._x - point.x);
            int n4 = this.startingBounds.y - (this._y - point.y);
            if (n3 + insets.left <= -this.__x) {
                n3 = -this.__x - insets.left;
            }
            if (n4 + insets.top <= -this.__y) {
                n4 = -this.__y - insets.top;
            }
            if (n3 + this.__x + insets.right > n) {
                n3 = n - this.__x - insets.right;
            }
            if (n4 + this.__y + insets.bottom > n2) {
                n4 = n2 - this.__y - insets.bottom;
            }
            if ((jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane()) != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.dragFrame(BasicDesktopIconUI.this.desktopIcon, n3, n4);
            } else {
                this.moveAndRepaint(BasicDesktopIconUI.this.desktopIcon, n3, n4, BasicDesktopIconUI.this.desktopIcon.getWidth(), BasicDesktopIconUI.this.desktopIcon.getHeight());
            }
        }

        public void moveAndRepaint(JComponent jComponent, int n, int n2, int n3, int n4) {
            Rectangle rectangle = jComponent.getBounds();
            jComponent.setBounds(n, n2, n3, n4);
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

