/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.util;

import org.mozilla.util.Range;
import org.mozilla.util.RangeException;

public final class ParameterCheck {
    private static final String RCSID = "$Id: ParameterCheck.java,v 1.2 1999/11/06 02:25:55 dmose%mozilla.org Exp $";

    private ParameterCheck() {
    }

    public static void nonNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object is null");
        }
    }

    public static void notEmpty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String is null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("String is empty");
        }
    }

    public static void noLessThan(int n, int n2) {
        if (n < n2) {
            throw new RangeException("Value " + n + " is out of range.  It is should be no less than " + n2);
        }
    }

    public static void greaterThan(int n, int n2) {
        if (n <= n2) {
            throw new RangeException("Value " + n + " is out of range.  It should be greater than " + n2);
        }
    }

    public static void noGreaterThan(int n, int n2) {
        if (n > n2) {
            throw new RangeException("Value " + n + "is out of " + "range. It should be no greater than " + n2);
        }
    }

    public static void lessThan(int n, int n2) {
        if (n >= n2) {
            throw new RangeException("Value " + n + " is out of range.  " + "It should be less than " + n2);
        }
    }

    public static void noLessThan(double d, double d2) {
        if (d < d2) {
            throw new RangeException("Value " + d + " is out of range.  " + "It should be no less than " + d2);
        }
    }

    public static void greaterThan(double d, double d2) {
        if (d <= d2) {
            throw new RangeException("Value " + d + " is out of range.  " + "It should be greater than " + d2);
        }
    }

    public static void noGreaterThan(double d, double d2) {
        if (d > d2) {
            throw new RangeException("Value " + d + " is out of range.  " + "It should be no greater than " + d2);
        }
    }

    public static void lessThan(double d, double d2) {
        if (d >= d2) {
            throw new RangeException("Value " + d + " is out of range.  It should be less than " + d2);
        }
    }

    public static void withinRange(int n, int n2, int n3) {
        ParameterCheck.noLessThan(n, n2);
        ParameterCheck.noGreaterThan(n, n3);
    }

    public static void withinRange(double d, double d2, double d3) {
        ParameterCheck.noLessThan(d, d2);
        ParameterCheck.noGreaterThan(d, d3);
    }

    public static void withinRange(int n, Range range) {
        if (!range.containsIndex(n)) {
            throw new RangeException("Value " + n + " should be in range " + range);
        }
    }

    public static void withinCount(int n, int n2) {
        ParameterCheck.withinRange(n, 0, n2 - 1);
    }

    public static void rangeWithinBounds(Range range, int n, int n2) {
        if (range.getStart() < n) {
            throw new RangeException("Range " + range + " should not contain indices less than " + n);
        }
        if (range.getEnd() > n2) {
            throw new RangeException("Range " + range + " should not contain indices greater than " + n2);
        }
    }

    public static void rangeWithinCount(Range range, int n) {
        ParameterCheck.rangeWithinBounds(range, 0, n - 1);
    }

    public static void rangeWithinString(Range range, String string) {
        ParameterCheck.nonNull(string);
        ParameterCheck.nonNull(range);
        if (range.getStart() < 0) {
            throw new RangeException("Range has negative start");
        }
        if (range.getMax() > string.length()) {
            throw new RangeException("Range extends beyond end of String");
        }
    }

    public static void isTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isFalse(boolean bl, String string) {
        if (bl) {
            throw new IllegalArgumentException(string);
        }
    }
}

