/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cachescheme;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import sun.plugin.protocol.JarDownloadFeedback;
import sun.plugin.usability.Trace;

public class PluginURLConnection {
    URL m_url = null;
    int noOfBytes = 8192;
    boolean isHeaderAvailable = false;
    long m_lastModified = 0L;
    int m_fileSize = 0;
    URLConnection m_conn = null;

    public PluginURLConnection(URL uRL, String string) throws IOException {
        this.m_url = new URL(uRL, string);
    }

    public synchronized long getLastModified() throws IOException {
        this.fetchHTTPHeaders();
        return this.m_lastModified;
    }

    public synchronized int getContentLength() throws IOException {
        this.fetchHTTPHeaders();
        return this.m_fileSize;
    }

    private void fetchHTTPHeaders() throws IOException {
        if (this.isHeaderAvailable) {
            return;
        }
        Trace.println("Determining time-stamp by connecting to " + this.m_url, 2);
        this.m_conn = this.m_url.openConnection();
        this.m_conn.setUseCaches(false);
        if (this.m_conn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.m_conn;
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.connect();
            this.m_fileSize = httpURLConnection.getContentLength();
            this.m_lastModified = httpURLConnection.getLastModified();
            httpURLConnection.disconnect();
            this.m_conn = null;
        } else {
            this.m_conn.connect();
            this.m_fileSize = this.m_conn.getContentLength();
            this.m_lastModified = this.m_conn.getLastModified();
        }
        this.isHeaderAvailable = true;
    }

    public void downLoadFile(File file) throws IOException {
        BufferedInputStream bufferedInputStream;
        block9: {
            bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            JarDownloadFeedback jarDownloadFeedback = null;
            try {
                this.fetchHTTPHeaders();
                if (this.m_conn == null) {
                    this.m_conn = this.m_url.openConnection();
                    this.m_conn.setUseCaches(false);
                }
                this.m_conn.connect();
                byte[] byArray = new byte[this.noOfBytes];
                bufferedInputStream = new BufferedInputStream(this.m_conn.getInputStream());
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n = this.getContentLength();
                int n2 = 0;
                int n3 = 0;
                jarDownloadFeedback = new JarDownloadFeedback(this.m_url.toString());
                jarDownloadFeedback.onStartBinding(n3, n);
                while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                    jarDownloadFeedback.onProgress(n3 += n2, n);
                }
                Object var10_9 = null;
                if (jarDownloadFeedback != null) {
                    jarDownloadFeedback.onStopBinding();
                }
                if (filterOutputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (jarDownloadFeedback != null) {
                    jarDownloadFeedback.onStopBinding();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                this.m_conn = null;
                throw throwable;
            }
            filterOutputStream.close();
        }
        if (bufferedInputStream != null) {
            bufferedInputStream.close();
        }
        this.m_conn = null;
    }
}

