/*
    * WINNT for Windows NT, 2000, XP and later
    * Linux for all Linux versions
    * Darwin for all MacOS X versions 
    */
var eMusicPlatform = {
  flashRoot: "Home",
  height: "600",
  width: "800",
  xOffset: "0",
  yOffset: "0",
  windowState: "",

  ident: Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo)
                  .QueryInterface(Components.interfaces.nsIXULRuntime)
                  .OS,
  
  newline: "\n",

  downloadDirectory: null,
  totalTracks: null,
  
  firstTimeRun: function() {
    //eMusicPlatform.installPlugin();

    var prefs = nsPreferences.mPrefService;
    var branchService = Components.classes["@mozilla.org/preferences-service;1"]
                                   .getService(Components.interfaces.nsIPrefBranch);

    // -- download directory settings 
    var thisPath = dlm_base.getSpecialFolder("Desk");
    thisPath.append("My eMusic");
    
    var iu = Components.classes["@emusic.com/insertutils;1"].createInstance(Components.interfaces.mozIInsertUtils);

    var obj_TargetFile =  Components.classes["@mozilla.org/file/directory_service;1"]
               .getService(Components.interfaces.nsIProperties).get("UsrPrfs", Components.interfaces.nsILocalFile);
    obj_TargetFile.append("com.emusic.DownloadManager.plist");

    if (obj_TargetFile.exists()) {
      /* --- old registry entries (Mac Only) */
      eMusicPlatform.downloadDirectory = iu.getKeyValue(obj_TargetFile, "DlmDownloadLocation");

      if (eMusicPlatform.downloadDirectory) {
        try {
          thisPath = dlm_base.getLocalFileInterface(eMusicPlatform.downloadDirectory);
        } catch (ex) {
        }
      }
    }
    
    if (branchService.prefHasUserValue("eMusic.download.dir")) {
      try {
        thisPath = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile)    
      } catch (ex) {
        edebug(ex)
      }
    } else  {
      prefs.setIntPref("eMusic.download.folderList", 2);
    }
    
    if (!thisPath.exists()) {
      // Make sure that path can and are created
      try {
        thisPath.create(0x01,0755);
      } catch (ex) {
        edebug(ex);
      }
    }

    try {
      prefs.setComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile, thisPath);
      prefs.setComplexValue("eMusic.download.downloadDir", Components.interfaces.nsILocalFile, thisPath);
    } catch (ex) {
      dlm_base.verifyDownloadDirectory()
    }
  },
  
  minimizeWindow: function() {
    var tempWin = dlm_base.mostRecentWindow("emusic:window").document.getElementById("main-window");

    window.minimize();
  },

  zoomWindow: function() {
    if (window.windowState == STATE_NORMAL) {
      window.maximize();
    } else {
      window.restore();
    }
  },
  
  installPlugin: function() {
    
    /*var pkgFolder = dlm_base.getSpecialFolder("resource:app");
  	pkgFolder.append("Plugin.pkg");

    var params = ["-a", pkgFolder.path];
    var stubLauncher = dlm_base.getLocalFileInterface("/usr/bin/open");

    var thisProcess = Components.classes["@mozilla.org/process/util;1"].
                        getService(Components.interfaces.nsIProcess);
    thisProcess.init(stubLauncher);
    
    thisProcess.run(false, params, params.length);*/

  }

}

var eMusicRegistry = {
  getValue: function(thisReg) {
  },

  setValue: function(thisReg, thisValue) {
  },
  
  resetStartup: function() {
  }
}

var legacyImport = {
  init: function() {
  
    var obj_TargetFile =  Components.classes["@mozilla.org/file/directory_service;1"]
               .getService(Components.interfaces.nsIProperties).get("UsrPrfs", Components.interfaces.nsIFile);
    obj_TargetFile.append("com.emusic.DownloadManager.plist");

    if (obj_TargetFile.exists()) {
      eWizard.importLegacy = true;
    }

  },

  legacyKickOff: function() {
    var iu = Components.classes["@emusic.com/insertutils;1"].createInstance(Components.interfaces.mozIInsertUtils);

    var obj_TargetFile =  Components.classes["@mozilla.org/file/directory_service;1"]
               .getService(Components.interfaces.nsIProperties).get("UsrPrfs", Components.interfaces.nsIFile);
    obj_TargetFile.append("com.emusic.DownloadManager.plist");

    /* --- old registry entries (Mac Only) */
    eMusicPlatform.downloadDirectory = iu.getKeyValue(obj_TargetFile, "DlmDownloadLocation");

    if (eMusicPlatform.downloadDirectory) {
      try {
        var thisPath = dlm_base.getLocalFileInterface(eMusicPlatform.downloadDirectory);
        var prefs = nsPreferences.mPrefService;

        if (thisPath.exists()) {
          prefs.setComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile, thisPath);
          prefs.setComplexValue("eMusic.download.downloadDir", Components.interfaces.nsILocalFile, thisPath);
        } else {
          dlm_base.verifyDownloadDirectory();
        }
      } catch (ex) {
      }
    }

    eMusicPlatform.totalTracks      = iu.getKeyValue(obj_TargetFile, "numberOfItems");
    var thisFileNamingTemplate      = iu.getKeyValue(obj_TargetFile, "DlmFilenameTemplate");
    var thisFileNamingSeparator     = iu.getKeyValue(obj_TargetFile, "DlmItemSeparatorString");
    var thisCreateAlbumDirectory    = iu.getKeyValue(obj_TargetFile, "DlmOrganizeByAlbum");
    var thisCreateArtistDirectory   = iu.getKeyValue(obj_TargetFile, "DlmOrganizeByArtist");
    var thisAutoClearCancelled      = iu.getKeyValue(obj_TargetFile, "DlmAutoClearCancelled");
    var thisQuitWhenDone            = iu.getKeyValue(obj_TargetFile, "DlmAutoCloseApplication");

    thisFileNamingTemplate = thisFileNamingTemplate.toLowerCase()

    var myRegEx = new RegExp(/[\{|\}|\$]/g);
    thisFileNamingTemplate = thisFileNamingTemplate.replace(myRegEx, "");
    thisFileNamingTemplate = thisFileNamingTemplate.replace("tracknumber", "number");
    thisFileNamingTemplate = thisFileNamingTemplate.replace("trackname", "track");

    //edebug("'"+thisCreateAlbumDirectory+"'")
    //edebug(thisFileNamingSeparator, thisFileNamingTemplate, thisCreateAlbumDirectory, thisCreateArtistDirectory, thisAutoClearCancelled, thisQuitWhenDone)
    if (thisFileNamingSeparator)    nsPreferences.setUnicharPref("eMusic.FileNamingSeparator", thisFileNamingSeparator);
    if (thisFileNamingTemplate)     nsPreferences.setUnicharPref("eMusic.FileNamingTemplate", thisFileNamingTemplate);

    var tmpPref = (thisCreateAlbumDirectory == "true") ? true : false
    nsPreferences.setBoolPref("eMusic.CreateAlbumDirectory", tmpPref);

    var tmpPref = (thisCreateArtistDirectory == "true") ? true : false
    nsPreferences.setBoolPref("eMusic.CreateArtistDirectory", tmpPref);

    var tmpPref = (thisAutoClearCancelled == "true") ? true : false
    nsPreferences.setBoolPref("eMusic.AutoClearCancelled", tmpPref);

    var tmpPref = (thisQuitWhenDone == "true") ? true : false
    nsPreferences.setBoolPref("eMusic.QuitWhenDone", tmpPref);
    
    // import filenaming template
    if (thisFileNamingTemplate) {
      var NameParts = thisFileNamingTemplate.split(thisFileNamingSeparator)
      for (var i = 0; i < NameParts.length; i++) {
        nsPreferences.setBoolPref("eMusic.template." + NameParts[i], true);
      }
    }
    
    document.getAnonymousElementByAttribute(document.getElementById('eWizard'), 'anonid', 'Header')
      .setAttribute("label", "Importing Download Manager 3.0 Settings...")

    document.getElementById("importButtons").hidden = true;

    document.getElementById('eWizard').getButton("back").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "true")
    document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "true")

    var thisCountStatus = document.getElementById("import-count")
    thisCountStatus.setAttribute("value", "");

    var thisStatusBar = document.getElementById("status-display")

    thisStatusBar.setAttribute("value", "Preparing DLM 3.0 Track List...");

    setTimeout(legacyImport.parseLegacy, 250);
  },
  
  parseLegacy: function() {
    var thisCountStatus = document.getElementById("import-count")
    var thisStatusBar = document.getElementById("status-display")

    try {
      var iu = Components.classes["@emusic.com/insertutils;1"]
                 .createInstance(Components.interfaces.mozIInsertUtils);

      var f =  Components.classes["@mozilla.org/file/directory_service;1"]
                 .getService(Components.interfaces.nsIProperties).get("UsrPrfs", Components.interfaces.nsIFile);
      f.append("com.emusic.DownloadManager.plist");

      //edebug(new Date(), f.path);

      var xmlDoc = iu.convertPlistToXML(f);

      thisCountStatus.setAttribute("style", "font-size: 45px; font-weight: bold;")
      var baseStatusMsg = "Importing " + eMusicPlatform.totalTracks + " DLM 3.0 Tracks"
      thisStatusBar.setAttribute("value", baseStatusMsg);

      //edebug(new Date(), xmlDoc.textContent);

      thisCountStatus.setAttribute("style", "font-size: 45px; font-weight: bold;")
      thisStatusBar.setAttribute("value", baseStatusMsg);

      setTimeout(function() {legacyImport.insertLegacy(xmlDoc)}, 250);
    } catch (ex) { 
      edebug(ex);
      document.getElementById("skipImport").hidden = true;
      document.getElementById('eWizard').getButton("back").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("next").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "false")
      document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "false")
    }

  },
  
  insertLegacy: function(xmlDoc) {
    var thisCountStatus = document.getElementById("import-count")
    var thisStatusBar = document.getElementById("status-display")

    try {
      var iu = Components.classes["@emusic.com/insertutils;1"]
                 .createInstance(Components.interfaces.mozIInsertUtils);

      //edebug(new Date(), "insertPlistXMLData started");

      iu.insertPlistXMLData(xmlDoc);

      edebug(new Date(), "insertPlistXMLData finished");

    } catch (ex) { 
      edebug(ex);
    } finally {
      //thisCountStatus.setAttribute("value", legacyImport.trackTotal);
      thisCountStatus.setAttribute("value", "");
      thisStatusBar.setAttribute("value", "Importing Complete!");

      var mainWindow = dlm_base.mostRecentWindow();

      if (mainWindow) {
        mainWindow.eDownloadsView.builder.rebuild();
      }

      document.getElementById('eWizard').getPageById("welcome").setAttribute("next", "player")
      document.getElementById("skipImport").hidden = true;
      document.getElementById('eWizard').getButton("back").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("next").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "false")
      document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "false")
    }
  }
}
