<%
Const IncludeType = 2 
Dim UploadSizeLimit
Dim LogFolder
LogFolder = Server.MapPath(".")
Const LogSeparator = ", "

Function GetUpload()
  Dim Result
  Set Result = Nothing
  If Request.ServerVariables("REQUEST_METHOD") = "POST" Then 
    Dim CT, PosB, Boundary, Length, PosE
    CT = Request.ServerVariables("HTTP_Content_Type") 
    If LCase(Left(CT, 19)) = "multipart/form-data" Then 

      PosB = InStr(LCase(CT), "boundary=") 
      If PosB > 0 Then Boundary = Mid(CT, PosB + 9)
		PosB = InStr(LCase(CT), "boundary=") 
		If PosB > 0 then 
			PosB = InStr(Boundary, ",")
			If PosB > 0 Then Boundary = Left(Boundary, PosB - 1)
			end if

			Length = CLng(Request.ServerVariables("HTTP_Content_Length")) 
			If "" & UploadSizeLimit <> "" Then
				UploadSizeLimit = CLng(UploadSizeLimit)
				
		        If Length > UploadSizeLimit Then
					'Request.BinaryRead (Length)
					Err.Raise 2, "GetUpload", "Upload size " & FormatNumber(Length, 0) & "B exceeds limit of " & FormatNumber(UploadSizeLimit, 0) & "B"				
					Exit Function
				End If
			End If
      
			If Length > 0 And Boundary <> "" Then 				
				Boundary = "--" & Boundary
				Dim Head, Binary
				Binary = Request.BinaryRead(Length) 
				Set Result = SeparateFields(Binary, Boundary)
				Binary = Empty 
			Else
				Err.Raise 10, "GetUpload", "Zero length request ."
			End If
		Else
			Err.Raise 11, "GetUpload", "No file sent."
		End If
	Else
		Err.Raise 1, "GetUpload", "Bad request method."
	End If
	Set GetUpload = Result

End Function

Function SeparateFields(Binary, Boundary)
  Dim PosOpenBoundary, PosCloseBoundary, PosEndOfHeader, isLastBoundary
  Dim Fields
  Boundary = StringToBinary(Boundary)

  PosOpenBoundary = InStrB(Binary, Boundary)
  PosCloseBoundary = InStrB(PosOpenBoundary + LenB(Boundary), Binary, Boundary, 0)  
  Set Fields = CreateObject("Scripting.Dictionary")
  dim szErr
  Do While (PosOpenBoundary > 0 And PosCloseBoundary > 0 And Not isLastBoundary)
    Dim HeaderContent, bFieldContent
    Dim Content_Disposition, FormFieldName, SourceFileName, Content_Type
    Dim TwoCharsAfterEndBoundary
    PosEndOfHeader = InStrB(PosOpenBoundary + Len(Boundary), Binary, StringToBinary(vbCrLf + vbCrLf))

    HeaderContent = MidB(Binary, PosOpenBoundary + LenB(Boundary) + 2, PosEndOfHeader - PosOpenBoundary - LenB(Boundary) - 2)
    
    bFieldContent = MidB(Binary, (PosEndOfHeader + 4), PosCloseBoundary - (PosEndOfHeader + 4) - 2)

    GetHeadFields BinaryToString(HeaderContent), FormFieldName, SourceFileName, Content_Disposition, Content_Type

    Dim FieldContent 
    Dim Field       
    Set Field = New clField
    Set FieldContent = New clByteArray
    FieldContent.ByteArray = bFieldContent

    Set Field.Value = FieldContent
    Field.Name = FormFieldName
    Field.ContentDisposition = Content_Disposition
    Field.FilePath = SourceFileName
    Field.FileName = GetFileName(SourceFileName)    
    Field.ContentType = Content_Type
    Field.Length = FieldContent.Length

    Dim dField
    dField = Fields(FormFieldName)
    if isempty (dField) then
      Set Fields(FormFieldName) = Field
    else
      if isarray(dField) then 
        ReDim Preserve dField(ubound(dField)+1)
        Set dField(ubound(dField) - 1) = Field
      else
        dField = Array(dField, Field)
      end if
      Fields(FormFieldName) = dField
    end if
    TwoCharsAfterEndBoundary = BinaryToString(MidB(Binary, PosCloseBoundary + LenB(Boundary), 2))
    isLastBoundary = TwoCharsAfterEndBoundary = "--"

    If Not isLastBoundary Then 
      PosOpenBoundary = PosCloseBoundary
      PosCloseBoundary = InStrB(PosOpenBoundary + LenB(Boundary), Binary, Boundary)
    End If
  Loop
  Set SeparateFields = Fields
End Function

Function GetHeadFields(ByVal Head, Name, FileName, Content_Disposition, Content_Type)
  Name = (SeparateField(Head, "name=", ";")) 'ltrim
  If Left(Name, 1) = """" Then Name = Mid(Name, 2, Len(Name) - 2)

  FileName = (SeparateField(Head, "filename=", ";")) 'ltrim
  If Left(FileName, 1) = """" Then FileName = Mid(FileName, 2, Len(FileName) - 2)

  Content_Disposition = LTrim(SeparateField(Head, "content-disposition:", ";"))
  Content_Type = LTrim(SeparateField(Head, "content-type:", ";"))
End Function

Function SeparateField(From, ByVal sStart, ByVal sEnd)
  Dim PosB, PosE, sFrom
  sFrom = LCase(From)
  PosB = InStr(sFrom, sStart)
  If PosB > 0 Then
    PosB = PosB + Len(sStart)
    PosE = InStr(PosB, sFrom, sEnd)
    If PosE = 0 Then PosE = InStr(PosB, sFrom, vbCrLf)
    If PosE = 0 Then PosE = Len(sFrom) + 1
    SeparateField = Mid(From, PosB, PosE - PosB)
  Else
    SeparateField = Empty
  End If
End Function

'Separetes file name from the full path of file
Function GetFileName(FullPath)
  Dim Pos, PosF
  PosF = 0
  For Pos = Len(FullPath) To 1 Step -1
    Select Case Mid(FullPath, Pos, 1)
      Case ":", "/", "\": PosF = Pos + 1: Pos = 0
    End Select
  Next
  If PosF = 0 Then PosF = 1
  GetFileName = Mid(FullPath, PosF)
End Function
'************** Upload Utilities - end


'************** Binary+MultiByte <-> String conversion fuctions
Function BinaryToString(Binary)
  '2001 Antonin Foller, PSTRUH Software
  'Optimized version of PureASP conversion function
  'Selects the best algorithm to convert binary data to String data
  Dim TempString 

  On Error Resume Next
  'Recordset conversion has a best functionality
  TempString = RSBinaryToString(Binary)
  If Len(TempString) <> LenB(Binary) then'Conversion error
    'We have to use multibyte version of BinaryToString
    TempString = MBBinaryToString(Binary)
  end if
  BinaryToString = TempString
End Function

Function MBBinaryToString(Binary)
  '1999 Antonin Foller, PSTRUH Software
  'MultiByte version of BinaryToString function
	'Optimized version of simple BinaryToString algorithm.
  dim cl1, cl2, cl3, pl1, pl2, pl3
  Dim L', nullchar
  cl1 = 1
  cl2 = 1
  cl3 = 1
  L = LenB(Binary)
  
  Do While cl1<=L
    pl3 = pl3 & Chr(AscB(MidB(Binary,cl1,1)))
    cl1 = cl1 + 1
    cl3 = cl3 + 1
    if cl3>300 then
      pl2 = pl2 & pl3
      pl3 = ""
      cl3 = 1
      cl2 = cl2 + 1
      if cl2>200 then
        pl1 = pl1 & pl2
        pl2 = ""
        cl2 = 1
      End If
    End If
  Loop
  MBBinaryToString = pl1 & pl2 & pl3
End Function


Function RSBinaryToString(xBinary)
  '1999 Antonin Foller, PSTRUH Software
  'This function converts binary data (VT_UI1 | VT_ARRAY or MultiByte string)
	'to string (BSTR) using ADO recordset
	'The fastest way - requires ADODB.Recordset
	'Use this function instead of MBBinaryToString if you have ADODB.Recordset installed
	'to eliminate problem with PureASP performance

	Dim Binary
	'MultiByte data must be converted to VT_UI1 | VT_ARRAY first.
	if vartype(xBinary) = 8 then Binary = MultiByteToBinary(xBinary) else Binary = xBinary
	
  Dim RS, LBinary
  Const adLongVarChar = 201
  Set RS = CreateObject("ADODB.Recordset")
  LBinary = LenB(Binary)
	
	if LBinary>0 then
		RS.Fields.Append "mBinary", adLongVarChar, LBinary
		RS.Open
		RS.AddNew
			RS("mBinary").AppendChunk Binary 
		RS.Update
		RSBinaryToString = RS("mBinary")
	Else
		RSBinaryToString = ""
	End If
End Function

Function MultiByteToBinary(MultiByte)
  ' This function converts multibyte string to real binary data (VT_UI1 | VT_ARRAY)
  ' Using recordset
  Dim RS, LMultiByte, Binary
  Const adLongVarBinary = 205
  Set RS = CreateObject("ADODB.Recordset")
  LMultiByte = LenB(MultiByte)
	if LMultiByte>0 then
		RS.Fields.Append "mBinary", adLongVarBinary, LMultiByte
		RS.Open
		RS.AddNew
			RS("mBinary").AppendChunk MultiByte & ChrB(0)
		RS.Update
		Binary = RS("mBinary").GetChunk(LMultiByte)
	End If
  MultiByteToBinary = Binary
End Function

Function StringToBinary(String)
  Dim I, B
  For I=1 to len(String)
    B = B & ChrB(Asc(Mid(String,I,1)))
  Next
  StringToBinary = B
End Function

Function BinaryToStringSimple(Binary)
  'Multibyte conversion idea.
  'not used.
  Dim I, S
  For I = 1 To LenB(Binary)
    S = S & Chr(AscB(MidB(Binary, I, 1)))
  Next
  BinaryToStringSimple = S
End Function
'************** Binary+MultiByte <-> String conversion fuctions - end


'The function simulates save of binary data using conversion to a string and filesystemobject
Function SaveBinaryData(FileName, ByteArray)
  Dim FS : Set FS = CreateObject("Scripting.FileSystemObject")
  Dim TextStream : Set TextStream = FS.CreateTextFile(FileName)  
  TextStream.Write BinaryToString(ByteArray) 'BinaryToString is in upload.inc.
  TextStream.Close
End Function

'************** ScriptUtilities ByteArray class emaulation
'ByteArray class is native implemented by ScriptUtilities library
'This is simple VBS code which simulates some of ScriptUtilities ByteArray functionality
'required for file upload
Class clByteArray
  'Stored bytearray.
  public ByteArray

  Public Default Property Get ba
    ba = ByteArray
  End Property	

  'Returns length of source binary data
  public Property Get Length
    Length = LenB(ByteArray)
  End Property	

  'Returns length of source binary data
  public Property Get String
    String = BinaryToString(ByteArray)
  End Property	

  'Stores the binary data to a file.
  Public Function SaveAs(FileName)
    SaveBinaryData FileName, ByteArray
  End Function
  
  public function GetString
	GetString = BinaryToString(ByteArray)
  end function
End Class

'One upload form field contains next properties.
Class clField
  Public Name, ContentDisposition, FileName, FilePath, ContentType, Value, Length
  Public Default Property Get n
    n = Name 
  End Property
End Class
'************** ScriptUtilities ByteArray class emaulation - end

'************** Special utilities
'Checks if all of required objects are installed
Function CheckRequirements()
  Dim Msg
  Msg = "<br><b>This script requires some default VBS objects installed to run properly.</b><br>" & vbCrLf
  Msg = Msg & CheckOneObject("ADODB.Recordset")
  Msg = Msg & CheckOneObject("Scripting.FileSystemObject")
  Msg = Msg & CheckOneObject("Scripting.Dictionary")
  CheckRequirements = Msg
'  MsgBox Msg
End Function

'Checks if the one object is installed.
Function CheckOneObject(oClass)
  Dim Msg
  On Error Resume Next
  CreateObject oClass
  If Err = 0 Then Msg = "OK" Else Msg = "Error:" & Err.Description
  CheckOneObject = oClass & " - " & Msg & "<br>" & vbCrLf
End Function
'Function UniqueFolderName
  'Creates unique name for the destination folder
 ' Dim UploadNumber
  'Application.Lock
   ' If Application("UploadNumber") = "" Then
   '   Application("UploadNumber") = 1
   ' Else
   '   Application("UploadNumber") = Application("UploadNumber") + 1
   ' End If
   ' UploadNumber = Application("UploadNumber")
  'Application.UnLock
'
 ' UniqueFolderName = Right("0" & Year(Now), 2) & Right("0" & Month(Now), 2) & Right("0" & Day(Now), 2) & "_" & Right("0" & Hour(Now), 2) & Right("0" & Minute(Now), 2) & Right("0" & Second(Now), 2) & "-" & UploadNumber
'End Function

'Writes one log line to the log file
Function DoLog(LogLine, LogPrefix)
  If LogFolder = "" Then LogFolder = Server.MapPath(".")
  Dim OutStream, FileName
  FileName = LogPrefix & Right("0" & Year(Now), 2) & Right("0" & Month(Now), 2) & Right("0" & Day(Now), 2) & ".LOG"

  Set OutStream = Server.CreateObject("Scripting.FileSystemObject").OpenTextFile(LogFolder & "\" & FileName, 8, True)
  OutStream.WriteLine Now() & LogSeparator & LogLine
  OutStream = Empty
End Function

'Returns field or "-" if field is empty
Function LogF(ByVal F)
	If "" & F = "" Then F = "-" Else F = "" & F
	F = replace(F, vbCrLf, "%13%10")
	F = replace(F, ",", "%2C")
	LogF = F
End Function

'Returns field or "-" if field is empty
Function LogFn(ByVal F)
  If "" & F = "" Then LogFn = "-" Else LogFn = formatnumber(F, 0)
End Function

Dim Kernel, TickCount, KernelTime, UserTime
Sub BeginTimer()
On Error Resume Next
  Set Kernel = CreateObject("ScriptUtils.Kernel") 'Creates the Kernel object
  'Get start times
  TickCount = Kernel.TickCount
  KernelTime = Kernel.CurrentThread.KernelTime
  UserTime = Kernel.CurrentThread.UserTime
On Error GoTo 0
End Sub

Sub EndTimer()
  'Write times
On Error Resume Next
  Response.Write "<br>Script time : " & (Kernel.TickCount - TickCount) & " ms"
  Response.Write "<br>Kernel time : " & CLng((Kernel.CurrentThread.KernelTime - KernelTime) * 86400000) & " ms"
  Response.Write "<br>User time : " & CLng((Kernel.CurrentThread.UserTime - UserTime) * 86400000) & " ms"
On Error GoTo 0
  Kernel = Empty
End Sub

'************** Special utilities - end
%>